/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.tree;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.json.tree.JsonScalar;

final class JsonString
extends JsonScalar {
    @NonNull
    private final String value;

    JsonString(@NonNull String value) {
        this.value = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof JsonString)) return false;
        JsonString js = (JsonString)o;
        if (!js.value.equals(this.value)) return false;
        return true;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    @NonNull
    public String getStringValue() {
        return this.value;
    }

    @Override
    @NonNull
    public String coerceStringValue() {
        return this.value;
    }
}

