/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.beans.impl;

import io.micronaut.context.BeanContext;
import io.micronaut.context.DisabledBean;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Requires;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.management.endpoint.beans.BeanDefinitionData;
import io.micronaut.management.endpoint.beans.BeanDefinitionDataCollector;
import io.micronaut.management.endpoint.beans.BeansEndpoint;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Singleton
@Requires(beans={BeansEndpoint.class})
public class DefaultBeanDefinitionDataCollector
implements BeanDefinitionDataCollector<Map<String, Object>> {
    private final BeanContext beanContext;
    private final BeanDefinitionData<Map<String, Object>> beanDefinitionData;

    DefaultBeanDefinitionDataCollector(BeanContext beanContext, BeanDefinitionData<Map<String, Object>> beanDefinitionData) {
        this.beanContext = beanContext;
        this.beanDefinitionData = beanDefinitionData;
    }

    @Override
    public Map<String, Object> getData() {
        LinkedHashMap<String, Object> beanData = new LinkedHashMap<String, Object>(1);
        List<BeanDefinition<?>> beanDefinitions = this.beanContext.getAllBeanDefinitions().stream().sorted(Comparator.comparing(bd -> bd.getClass().getName())).toList();
        beanData.put("beans", this.getBeans(beanDefinitions));
        beanData.put("disabled", this.getDisabledBeans());
        return beanData;
    }

    protected Map<String, Map<String, Object>> getBeans(Collection<BeanDefinition<?>> definitions) {
        return definitions.stream().collect(Collectors.toMap(definition -> definition.getClass().getName(), this.beanDefinitionData::getData));
    }

    protected List<Map<String, Object>> getDisabledBeans() {
        Collection<DisabledBean<?>> disabledBeans = this.beanContext.getDisabledBeans();
        return disabledBeans.stream().map(disabledBean -> {
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            data.put("type", disabledBean.type().getTypeName());
            Qualifier q = disabledBean.qualifier();
            if (q != null) {
                data.put("qualifier", q.toString());
            }
            data.put("reasons", disabledBean.reasons());
            return data;
        }).toList();
    }
}

