/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.beans;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Mapper;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import jakarta.inject.Singleton;
import java.util.function.Supplier;

@Internal
@Singleton
final class MapperMethodProcessor
implements ExecutableMethodProcessor<Mapper> {
    private final MutableConversionService mutableConversionService;
    private final ApplicationContext applicationContext;

    MapperMethodProcessor(MutableConversionService mutableConversionService, ApplicationContext applicationContext) {
        this.mutableConversionService = mutableConversionService;
        this.applicationContext = applicationContext;
    }

    @Override
    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        Class<?>[] argumentTypes = method.getArgumentTypes();
        if (method.hasDeclaredAnnotation(Mapper.class) && argumentTypes.length == 1) {
            Class toType = method.getReturnType().getType();
            Class<?> fromType = argumentTypes[0];
            ExecutableMethod<?, ?> finalMethod = method;
            Supplier<Object> beanSupplier = SupplierUtil.memoized(() -> this.applicationContext.getBean(beanDefinition));
            this.mutableConversionService.addConverter(fromType, toType, object -> finalMethod.invoke(beanSupplier.get(), object));
        }
    }
}

