/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.async;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.ReturnType;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.scheduling.TaskExecutors;
import io.micronaut.scheduling.annotation.Async;
import io.micronaut.scheduling.exceptions.TaskExecutionException;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
public class AsyncInterceptor
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutors.class);
    private final ConversionService conversionService;
    private final BeanLocator beanLocator;
    private final Optional<BeanProvider<ExecutorService>> scheduledExecutorService;
    private final Map<String, ExecutorService> scheduledExecutorServices = new ConcurrentHashMap<String, ExecutorService>();

    AsyncInterceptor(ConversionService conversionService, BeanLocator beanLocator, @Named(value="scheduled") Optional<BeanProvider<ExecutorService>> scheduledExecutorService) {
        this.conversionService = conversionService;
        this.beanLocator = beanLocator;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public int getOrder() {
        return InterceptPhase.ASYNC.getPosition();
    }

    @Override
    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        String executorServiceName = context.stringValue(Async.class).orElse("scheduled");
        ExecutorService executorService = "scheduled".equals(executorServiceName) && this.scheduledExecutorService.isPresent() ? this.scheduledExecutorService.get().get() : this.scheduledExecutorServices.computeIfAbsent(executorServiceName, name -> this.beanLocator.findBean(ExecutorService.class, Qualifiers.byName(name)).orElseThrow(() -> new TaskExecutionException("No ExecutorService named [" + name + "] configured in application context")));
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, this.conversionService);
        try {
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    return interceptedMethod.handleResult(interceptedMethod.interceptResultAsPublisher(executorService));
                }
                case COMPLETION_STAGE: {
                    return interceptedMethod.handleResult(CompletableFuture.supplyAsync(() -> interceptedMethod.interceptResultAsCompletionStage(), executorService).thenCompose(Function.identity()));
                }
                case SYNCHRONOUS: {
                    ReturnType rt = context.getReturnType();
                    Class returnType = rt.getType();
                    if (Void.TYPE == returnType) {
                        executorService.submit(() -> {
                            block2: {
                                try {
                                    context.proceed();
                                }
                                catch (Throwable e) {
                                    if (!LOG.isErrorEnabled()) break block2;
                                    LOG.error("Error occurred executing @Async method [{}]: {}", context.getExecutableMethod(), e.getMessage(), e);
                                }
                            }
                        });
                        return null;
                    }
                    throw new TaskExecutionException("Method [" + context.getExecutableMethod() + "] must return either void, or an instance of Publisher or CompletionStage");
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }
}

