/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBean;
import java.io.IOException;

final class JsonValueDeserializer
implements Deserializer<Object> {
    private final DeserBean<? super Object> deserBean;

    JsonValueDeserializer(DeserBean<? super Object> deserBean) {
        this.deserBean = deserBean;
    }

    @Override
    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> beanType) throws IOException {
        if (this.deserBean.creatorSize == 0) {
            throw new SerdeException("Expected at least one constructor parameter");
        }
        Object[] params = new Object[1];
        DeserBean.DerProperty constructorJsonValue = this.deserBean.creatorParams.getDerProperties().get(0);
        if (constructorJsonValue != null) {
            constructorJsonValue.deserializeAndSetConstructorValue(decoder, decoderContext, params);
        }
        try {
            return this.deserBean.introspection.instantiate(params);
        }
        catch (InstantiationException e) {
            throw new SerdeException("Unable to deserialize type [" + beanType + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public Object deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Object> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }
}

