/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.reference.PropertyReference;
import io.micronaut.serde.support.deserializers.DeserializeSubtypeInfo;
import java.io.IOException;
import java.util.Map;

final class SubtypedExternalPropertyObjectDeserializer
implements Deserializer<Object> {
    private final DeserializeSubtypeInfo<?> subtypeInfo;
    private final Map<String, Deserializer<Object>> deserializers;

    SubtypedExternalPropertyObjectDeserializer(DeserializeSubtypeInfo<?> subtypeInfo, Map<String, Deserializer<Object>> deserializers) {
        this.subtypeInfo = subtypeInfo;
        this.deserializers = deserializers;
    }

    static PropertyReference<Object, String> createExternalPropertyReference(Deserializer.DecoderContext decoderContext, String discriminator, String value) {
        String referenceName = "externalProperty@" + discriminator;
        return decoderContext.resolveReference(new PropertyReference(referenceName, null, Argument.of(String.class, referenceName), value));
    }

    @Override
    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
        PropertyReference<Object, String> externalPropertyReference = SubtypedExternalPropertyObjectDeserializer.createExternalPropertyReference(decoderContext, this.subtypeInfo.info().discriminatorName(), null);
        PropertyReference<Object, String> ref = decoderContext.resolveReference(externalPropertyReference);
        String subtypeName = (String)ref.getReference();
        Deserializer<Object> deserializer = this.deserializers.get(subtypeName);
        if (deserializer == null && this.subtypeInfo.defaultDiscriminator() != null) {
            deserializer = this.deserializers.get(this.subtypeInfo.defaultDiscriminator());
        }
        if (deserializer == null) {
            throw new SerdeException("Cannot find subtype deserializer for discriminator: " + subtypeName + "  and argument: [" + type + "]");
        }
        return deserializer.deserialize(decoder, decoderContext, type);
    }
}

