/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import java.io.IOException;
import java.util.Collection;

final class RuntimeValueIterableSerializer<T>
implements Serializer<Iterable<T>> {
    RuntimeValueIterableSerializer() {
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Iterable<T>> type, Iterable<T> value) throws IOException {
        Encoder childEncoder = encoder.encodeArray(type);
        Class<?> lastValueClass = null;
        Serializer<?> componentSerializer = null;
        Argument<?> generic2 = null;
        for (T t2 : value) {
            if (t2 == null) {
                encoder.encodeNull();
                continue;
            }
            if (lastValueClass != t2.getClass() || componentSerializer == null) {
                generic2 = Argument.of(t2.getClass());
                componentSerializer = context.findSerializer(generic2).createSpecific(context, generic2);
                lastValueClass = t2.getClass();
            }
            componentSerializer.serialize(childEncoder, context, generic2, t2);
        }
        childEncoder.finishStructure();
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, Iterable<T> value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        return !value.iterator().hasNext();
    }

    @Override
    public boolean isAbsent(Serializer.EncoderContext context, Iterable<T> value) {
        return value == null;
    }
}

