/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import java.io.IOException;
import java.util.Collection;

final class StringIterableSerializer
implements Serializer<Iterable<String>> {
    static final StringIterableSerializer INSTANCE = new StringIterableSerializer();

    StringIterableSerializer() {
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Iterable<String>> type, Iterable<String> values) throws IOException {
        Encoder childEncoder = encoder.encodeArray(type);
        for (String value : values) {
            if (value == null) {
                encoder.encodeNull();
                continue;
            }
            childEncoder.encodeString(value);
        }
        childEncoder.finishStructure();
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, Iterable<String> value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        return !value.iterator().hasNext();
    }

    @Override
    public boolean isAbsent(Serializer.EncoderContext context, Iterable<String> value) {
        return value == null;
    }
}

