/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import java.io.IOException;

@Internal
final class WrappedArraySerializer<T>
implements Serializer<T> {
    private final Serializer<T> serializer;
    private final String wrapperProperty;

    WrappedArraySerializer(Serializer<T> serializer, String wrapperProperty) {
        this.serializer = serializer;
        this.wrapperProperty = wrapperProperty;
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        try (Encoder wrapperEncoder = encoder.encodeArray(Argument.OBJECT_ARGUMENT);){
            wrapperEncoder.encodeString(this.wrapperProperty);
            this.serializer.serialize(wrapperEncoder, context, type, (T)value);
        }
    }
}

