/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.embedded;

import io.micronaut.core.io.ResourceLoader;
import io.micronaut.testresources.core.LazyTestResourcesPropertySourceLoader;
import io.micronaut.testresources.core.PropertyExpressionProducer;
import io.micronaut.testresources.core.TestResourcesResolver;
import io.micronaut.testresources.core.ToggableTestResourcesResolver;
import io.micronaut.testresources.embedded.TestResourcesResolverLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class EmbeddedTestResourcesPropertySourceLoader
extends LazyTestResourcesPropertySourceLoader {
    private static final Pattern CAMEL_CASE = Pattern.compile("([a-z])([A-Z])");

    public EmbeddedTestResourcesPropertySourceLoader() {
        super(new EmbeddedTestResourcesProducer());
    }

    private static class EmbeddedTestResourcesProducer
    implements PropertyExpressionProducer {
        private final TestResourcesResolverLoader loader = TestResourcesResolverLoader.getInstance();

        private EmbeddedTestResourcesProducer() {
        }

        @Override
        public List<String> getPropertyEntries() {
            return this.loader.getResolvers().stream().flatMap(resolver -> resolver.getRequiredPropertyEntries().stream()).distinct().collect(Collectors.toList());
        }

        @Override
        public List<String> produceKeys(ResourceLoader resourceLoader, Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
            return this.loader.getResolvers().stream().filter(r -> EmbeddedTestResourcesProducer.isEnabled(r, testResourcesConfig)).flatMap(r -> r.getResolvableProperties(propertyEntries, testResourcesConfig).stream().map(key -> EmbeddedTestResourcesProducer.assertValidKey(key, r))).distinct().toList();
        }

        private static String assertValidKey(String key, TestResourcesResolver r) {
            Matcher m4 = CAMEL_CASE.matcher(key);
            if (m4.find()) {
                throw new IllegalArgumentException("Test resources resolver [" + r.getClass().getName() + "] : Property key [" + key + "] is not valid. Property keys must be in kebab case.");
            }
            return key;
        }

        private static boolean isEnabled(TestResourcesResolver resolver, Map<String, Object> testResourcesConfig) {
            if (resolver instanceof ToggableTestResourcesResolver) {
                ToggableTestResourcesResolver toggable = (ToggableTestResourcesResolver)resolver;
                return toggable.isEnabled(testResourcesConfig);
            }
            return true;
        }
    }
}

