/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.server;

import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.testresources.server.Ping;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@InterceptorBean(value={Ping.class})
public final class ExpiryManager
implements MethodInterceptor<Object, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpiryManager.class);
    private static final long MS_IN_ONE_MINUTE = 60000L;
    private final long timeoutMs;
    private long lastAccess;

    public ExpiryManager(@Value(value="${server.idle.timeout.minutes:60}") int keepAliveMinutes) {
        this.timeoutMs = (long)keepAliveMinutes * 60000L;
        this.ping();
        LOGGER.info("Test resources server will automatically be shutdown if it doesn't receive requests for {} minutes", (Object)keepAliveMinutes);
    }

    private void ping() {
        this.lastAccess = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.lastAccess > this.timeoutMs;
    }

    @Override
    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        this.ping();
        return context.proceed();
    }
}

