/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.slf4j.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerFetchException;
import org.testcontainers.images.ImagePullPolicy;
import org.testcontainers.images.LocalImagesCache;
import org.testcontainers.images.PullPolicy;
import org.testcontainers.images.TimeLimitedLoggedPullImageResultCallback;
import org.testcontainers.shaded.com.google.common.util.concurrent.Futures;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.DockerLoggerFactory;
import org.testcontainers.utility.ImageNameSubstitutor;
import org.testcontainers.utility.LazyFuture;

public class RemoteDockerImage
extends LazyFuture<String> {
    private static final Duration PULL_RETRY_TIME_LIMIT = Duration.ofMinutes(2L);
    private Future<DockerImageName> imageNameFuture;
    ImagePullPolicy imagePullPolicy = PullPolicy.defaultPolicy();
    private ImageNameSubstitutor imageNameSubstitutor = ImageNameSubstitutor.instance();
    private DockerClient dockerClient = DockerClientFactory.lazyClient();

    public RemoteDockerImage(DockerImageName dockerImageName) {
        this.imageNameFuture = CompletableFuture.completedFuture(dockerImageName);
    }

    @Deprecated
    public RemoteDockerImage(String dockerImageName) {
        this(DockerImageName.parse(dockerImageName));
    }

    @Deprecated
    public RemoteDockerImage(@NonNull String repository, @NonNull String tag) {
        this(DockerImageName.parse(repository).withTag(tag));
        if (repository == null) {
            throw new NullPointerException("repository is marked non-null but is null");
        }
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
    }

    public RemoteDockerImage(@NonNull Future<String> imageFuture) {
        if (imageFuture == null) {
            throw new NullPointerException("imageFuture is marked non-null but is null");
        }
        this.imageNameFuture = Futures.lazyTransform(imageFuture, DockerImageName::new);
    }

    @Override
    protected final String resolve() {
        DockerImageName imageName = this.getImageName();
        Logger logger = DockerLoggerFactory.getLogger(imageName.toString());
        try {
            if (!this.imagePullPolicy.shouldPull(imageName)) {
                return imageName.asCanonicalNameString();
            }
            logger.info("Pulling docker image: {}. Please be patient; this may take some time but only needs to be done once.", (Object)imageName);
            Exception lastFailure = null;
            Instant lastRetryAllowed = Instant.now().plus(PULL_RETRY_TIME_LIMIT);
            Instant startedAt = Instant.now();
            while (Instant.now().isBefore(lastRetryAllowed)) {
                try {
                    PullImageCmd pullImageCmd = this.dockerClient.pullImageCmd(imageName.getUnversionedPart()).withTag(imageName.getVersionPart());
                    try {
                        pullImageCmd.exec(new TimeLimitedLoggedPullImageResultCallback(logger)).awaitCompletion();
                    }
                    catch (DockerClientException e) {
                        pullImageCmd.withPlatform("linux/amd64").exec(new TimeLimitedLoggedPullImageResultCallback(logger)).awaitCompletion();
                    }
                    String dockerImageName = imageName.asCanonicalNameString();
                    logger.info("Image {} pull took {}", (Object)dockerImageName, (Object)Duration.between(startedAt, Instant.now()));
                    LocalImagesCache.INSTANCE.refreshCache(imageName);
                    return dockerImageName;
                }
                catch (InternalServerErrorException | InterruptedException e) {
                    lastFailure = e;
                    logger.warn("Retrying pull for image: {} ({}s remaining)", (Object)imageName, (Object)Duration.between(Instant.now(), lastRetryAllowed).getSeconds());
                }
            }
            logger.error("Failed to pull image: {}. Please check output of `docker pull {}`", imageName, imageName, lastFailure);
            throw new ContainerFetchException("Failed to pull image: " + imageName, lastFailure);
        }
        catch (DockerClientException e) {
            throw new ContainerFetchException("Failed to get Docker client for " + imageName, e);
        }
    }

    private DockerImageName getImageName() throws InterruptedException, ExecutionException {
        DockerImageName specifiedImageName = this.imageNameFuture.get();
        return this.imageNameSubstitutor.apply(specifiedImageName);
    }

    private String imageNameToString() {
        if (!this.imageNameFuture.isDone()) {
            return "<resolving>";
        }
        try {
            return this.getImageName().asCanonicalNameString();
        }
        catch (InterruptedException | ExecutionException e) {
            return e.getMessage();
        }
    }

    public String toString() {
        return "RemoteDockerImage(imageName=" + this.imageNameToString() + ", imagePullPolicy=" + this.imagePullPolicy + ", imageNameSubstitutor=" + this.imageNameSubstitutor + ")";
    }

    RemoteDockerImage(Future<DockerImageName> imageNameFuture, ImagePullPolicy imagePullPolicy, ImageNameSubstitutor imageNameSubstitutor, DockerClient dockerClient) {
        this.imageNameFuture = imageNameFuture;
        this.imagePullPolicy = imagePullPolicy;
        this.imageNameSubstitutor = imageNameSubstitutor;
        this.dockerClient = dockerClient;
    }

    public RemoteDockerImage withImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        return this.imagePullPolicy == imagePullPolicy ? this : new RemoteDockerImage(this.imageNameFuture, imagePullPolicy, this.imageNameSubstitutor, this.dockerClient);
    }

    public RemoteDockerImage withImageNameSubstitutor(ImageNameSubstitutor imageNameSubstitutor) {
        return this.imageNameSubstitutor == imageNameSubstitutor ? this : new RemoteDockerImage(this.imageNameFuture, this.imagePullPolicy, imageNameSubstitutor, this.dockerClient);
    }
}

