/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.filter.FilterContext;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.InternalHttpFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiFunction;

@Internal
public class FilterRunner {
    private final List<InternalHttpFilter> filters;
    private final BiFunction<HttpRequest<?>, PropagatedContext, ExecutionFlow<HttpResponse<?>>> responseProvider;

    public FilterRunner(List<GenericHttpFilter> filters, BiFunction<HttpRequest<?>, PropagatedContext, ExecutionFlow<HttpResponse<?>>> responseProvider) {
        this.filters = filters;
        this.responseProvider = responseProvider;
    }

    private static void checkOrdered(List<? extends GenericHttpFilter> filters) {
        if (!filters.stream().allMatch(f -> f instanceof Ordered)) {
            throw new IllegalStateException("Some filters cannot be ordered: " + filters);
        }
    }

    public static void sort(@NonNull List<GenericHttpFilter> filters) {
        FilterRunner.checkOrdered(filters);
        OrderUtil.sort(filters);
    }

    public static void sortReverse(@NonNull List<GenericHttpFilter> filters) {
        FilterRunner.checkOrdered(filters);
        OrderUtil.reverseSort(filters);
    }

    protected ExecutionFlow<HttpResponse<?>> processResponse(HttpRequest<?> request, HttpResponse<?> response, PropagatedContext propagatedContext) {
        return ExecutionFlow.just(response);
    }

    @Nullable
    protected ExecutionFlow<HttpResponse<?>> processFailure(HttpRequest<?> request, Throwable failure, PropagatedContext propagatedContext) {
        return null;
    }

    public final ExecutionFlow<HttpResponse<?>> run(HttpRequest<?> request) {
        return this.run(request, PropagatedContext.getOrEmpty());
    }

    public final ExecutionFlow<HttpResponse<?>> run(HttpRequest<?> request, PropagatedContext propagatedContext) {
        ArrayList<InternalHttpFilter> filtersToRun = new ArrayList<InternalHttpFilter>(this.filters.size());
        for (InternalHttpFilter filter : this.filters) {
            if (!filter.isEnabled(request)) continue;
            filtersToRun.add(filter);
        }
        if (filtersToRun.isEmpty()) {
            return this.responseProvider.apply(request, propagatedContext);
        }
        ListIterator<InternalHttpFilter> iterator = filtersToRun.listIterator();
        ExecutionFlow<FilterContext> flow = this.filterRequest(new FilterContext(request, propagatedContext), iterator);
        FilterContext flowContext = flow.tryCompleteValue();
        if (flowContext != null) {
            return this.filterResponse(flowContext, iterator, null);
        }
        return flow.flatMap(context -> this.filterResponse((FilterContext)context, iterator, null));
    }

    private ExecutionFlow<FilterContext> filterRequest(FilterContext context, ListIterator<InternalHttpFilter> iterator) {
        while (iterator.hasNext()) {
            ExecutionFlow<FilterContext> flow;
            InternalHttpFilter filter = iterator.next();
            if (!filter.isFiltersRequest()) continue;
            if (filter.hasContinuation()) {
                flow = filter.processRequestFilter(context, newContext -> {
                    if (newContext.response() != null) {
                        return ExecutionFlow.just(newContext);
                    }
                    return this.filterRequest((FilterContext)newContext, iterator);
                });
            } else {
                flow = filter.processRequestFilter(context);
                FilterContext flowContext = flow.tryCompleteValue();
                if (flowContext != null) {
                    if (context == flowContext) continue;
                    if (flowContext.response() != null) {
                        return ExecutionFlow.just(flowContext);
                    }
                    context = flowContext;
                    continue;
                }
                flow = flow.flatMap(newContext -> {
                    if (newContext.response() != null) {
                        return ExecutionFlow.just(newContext);
                    }
                    return this.filterRequest((FilterContext)newContext, iterator);
                });
            }
            FilterContext finalContext = context;
            return flow.onErrorResume(throwable -> this.processFailureFilterException(finalContext, iterator, (Throwable)throwable));
        }
        return this.provideResponse(context, iterator);
    }

    private ExecutionFlow<HttpResponse<?>> filterResponse(FilterContext context, ListIterator<InternalHttpFilter> iterator, @Nullable Throwable exception) {
        while (iterator.hasPrevious()) {
            InternalHttpFilter filter = iterator.previous();
            if (!filter.isFiltersResponse()) continue;
            ExecutionFlow<FilterContext> flow = filter.processResponseFilter(context, exception);
            FilterContext flowContext = flow.tryCompleteValue();
            if (flowContext != null) {
                if (context == flowContext) continue;
                flow = this.processResponse(flowContext.request(), flowContext.response(), flowContext.propagatedContext()).map(flowContext::withResponse);
                exception = null;
                flowContext = flow.tryCompleteValue();
                if (flowContext != null) {
                    context = flowContext;
                    continue;
                }
            }
            FilterContext finalContext = context;
            Throwable finalException = exception;
            return flow.flatMap(newContext -> {
                if (finalContext != newContext) {
                    return this.processResponse(newContext.request(), newContext.response(), newContext.propagatedContext()).map(newContext::withResponse);
                }
                return ExecutionFlow.just(newContext);
            }).onErrorResume(throwable -> this.processFailurePropagateException((Throwable)throwable, finalContext)).flatMap(newContext -> this.filterResponse((FilterContext)newContext, iterator, newContext.response() == null ? finalException : null));
        }
        if (context.response() != null) {
            return ExecutionFlow.just(context.response());
        }
        if (exception != null) {
            return ExecutionFlow.error(exception);
        }
        return ExecutionFlow.error(new IllegalStateException("No response after response filters completed!"));
    }

    private ExecutionFlow<FilterContext> processFailurePropagateException(Throwable throwable, FilterContext context) {
        ExecutionFlow<HttpResponse<?>> flow = this.processFailure(context.request(), throwable, context.propagatedContext());
        if (flow == null) {
            return ExecutionFlow.error(throwable);
        }
        return flow.map(context::withResponse);
    }

    private ExecutionFlow<FilterContext> provideResponse(FilterContext context, ListIterator<InternalHttpFilter> iterator) {
        ExecutionFlow<HttpResponse<?>> flow = this.responseProvider.apply(context.request(), context.propagatedContext());
        if (flow.tryCompleteValue() != null) {
            return flow.map(context::withResponse);
        }
        return flow.map(context::withResponse).onErrorResume(throwable -> this.processFailureFilterException(context, iterator, (Throwable)throwable));
    }

    private ExecutionFlow<FilterContext> processFailureFilterException(FilterContext context, ListIterator<InternalHttpFilter> iterator, Throwable throwable) {
        ExecutionFlow<HttpResponse<?>> flow = this.processFailure(context.request(), throwable, context.propagatedContext());
        if (flow == null) {
            return this.filterResponse(context, iterator, throwable).map(context::withResponse);
        }
        return flow.map(context::withResponse);
    }
}

