/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.ChunkedMessageBodyReader;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.body.CustomizableNettyJsonHandler;
import io.micronaut.http.netty.body.JsonChunkedProcessor;
import io.micronaut.http.netty.body.NettyBodyWriter;
import io.micronaut.http.netty.body.NettyWriteContext;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.body.JsonMessageHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
@Internal
@Replaces(value=JsonMessageHandler.class)
@Produces(value={"application/json", "text/json", "application/hal+json", "application/vnd.github+json", "application/feed+json", "application/json-patch+json", "application/merge-patch+json", "application/problem+json"})
@Consumes(value={"application/json", "text/json", "application/hal+json", "application/vnd.github+json", "application/feed+json", "application/json-patch+json", "application/merge-patch+json", "application/problem+json"})
@BootstrapContextCompatible
@Requires(beans={JsonMapper.class})
public final class NettyJsonHandler<T>
implements MessageBodyHandler<T>,
ChunkedMessageBodyReader<T>,
CustomizableNettyJsonHandler,
NettyBodyWriter<T> {
    private final JsonMessageHandler<T> jsonMessageHandler;

    public NettyJsonHandler(JsonMapper jsonMapper) {
        this(new JsonMessageHandler(jsonMapper));
    }

    private NettyJsonHandler(JsonMessageHandler<T> jsonMessageHandler) {
        this.jsonMessageHandler = jsonMessageHandler;
    }

    @Override
    public CustomizableNettyJsonHandler customize(JsonFeatures jsonFeatures) {
        return new NettyJsonHandler<T>(this.jsonMessageHandler.getJsonMapper().cloneWithFeatures(jsonFeatures));
    }

    @Override
    public Publisher<T> readChunked(Argument<T> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
        JsonChunkedProcessor processor = new JsonChunkedProcessor();
        if (Iterable.class.isAssignableFrom(type.getType())) {
            processor.counter.noTokenization();
        } else {
            processor.counter.unwrapTopLevelArray();
        }
        return processor.process(Flux.from(input).map(bb -> {
            Object patt4476$temp = bb.asNativeBuffer();
            if (!(patt4476$temp instanceof ByteBuf)) {
                throw new IllegalArgumentException("Only netty buffers are supported");
            }
            ByteBuf buf = (ByteBuf)patt4476$temp;
            return buf;
        })).map(bb -> this.read(type, mediaType, httpHeaders, (ByteBuffer<?>)bb));
    }

    @Override
    public boolean isReadable(Argument<T> type, MediaType mediaType) {
        return this.jsonMessageHandler.isReadable(type, mediaType);
    }

    @Override
    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
        return this.jsonMessageHandler.read(type, mediaType, httpHeaders, byteBuffer);
    }

    @Override
    public T read(Argument<T> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        return this.jsonMessageHandler.read(type, mediaType, httpHeaders, inputStream);
    }

    @Override
    public boolean isWriteable(Argument<T> type, MediaType mediaType) {
        return this.jsonMessageHandler.isWriteable(type, mediaType);
    }

    @Override
    public void writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        this.jsonMessageHandler.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
    }

    @Override
    public ByteBuffer<?> writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
        return this.jsonMessageHandler.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory);
    }

    @Override
    public void writeTo(@NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<T> outgoingResponse, @NonNull Argument<T> type, @NonNull MediaType mediaType, @NonNull T object, @NonNull NettyWriteContext nettyContext) throws CodecException {
        NettyHttpHeaders nettyHttpHeaders = (NettyHttpHeaders)outgoingResponse.getHeaders();
        if (!nettyHttpHeaders.contains("Content-Type")) {
            nettyHttpHeaders.set(HttpHeaderNames.CONTENT_TYPE, mediaType);
        }
        ByteBuf buffer = nettyContext.alloc().buffer();
        JsonMapper jsonMapper = this.jsonMessageHandler.getJsonMapper();
        try {
            jsonMapper.writeValue(new ByteBufOutputStream(buffer), object);
        }
        catch (IOException e) {
            buffer.release();
            throw new CodecException("Error encoding object [" + object + "] to JSON: " + e.getMessage(), e);
        }
        nettyContext.writeFull(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(outgoingResponse.code(), outgoingResponse.reason()), buffer, nettyHttpHeaders.getNettyHeaders(), EmptyHttpHeaders.INSTANCE));
    }

    @Override
    public MessageBodyWriter<T> createSpecific(Argument<T> type) {
        return new NettyJsonHandler<T>((JsonMessageHandler)this.jsonMessageHandler.createSpecific(type));
    }

    @Override
    public boolean isBlocking() {
        return this.jsonMessageHandler.isBlocking();
    }
}

