/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.bind.binders.PendingRequestBindingResult;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.DefaultHttpContentProcessorResolver;
import io.micronaut.http.server.netty.FormDataHttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.binders.NettyPartUploadAnnotationBinder;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.body.ImmediateByteBody;
import io.micronaut.web.router.RouteInfo;
import java.util.List;
import java.util.Optional;

final class NettyBodyAnnotationBinder<T>
extends DefaultBodyAnnotationBinder<T> {
    private static final CharSequence ATTR_CONVERTIBLE_BODY = "NettyBodyAnnotationBinder.convertibleBody";
    final HttpServerConfiguration httpServerConfiguration;
    final MessageBodyHandlerRegistry bodyHandlerRegistry;

    NettyBodyAnnotationBinder(ConversionService conversionService, HttpServerConfiguration httpServerConfiguration, MessageBodyHandlerRegistry bodyHandlerRegistry) {
        super(conversionService);
        this.httpServerConfiguration = httpServerConfiguration;
        this.bodyHandlerRegistry = bodyHandlerRegistry;
    }

    @Override
    protected ArgumentBinder.BindingResult<T> bindBodyPart(ArgumentConversionContext<T> context, HttpRequest<?> source, String bodyComponent) {
        NettyHttpRequest nhr;
        if (source instanceof NettyHttpRequest && (nhr = (NettyHttpRequest)source).isFormOrMultipartData()) {
            return NettyPartUploadAnnotationBinder.bindPart(this.conversionService, context, nhr, bodyComponent, true);
        }
        return super.bindBodyPart(context, source, bodyComponent);
    }

    @Override
    protected ArgumentBinder.BindingResult<ConvertibleValues<?>> bindFullBodyConvertibleValues(HttpRequest<?> source) {
        if (!(source instanceof NettyHttpRequest)) {
            return super.bindFullBodyConvertibleValues(source);
        }
        NettyHttpRequest nhr = (NettyHttpRequest)source;
        Optional<Object> existing = nhr.getAttribute(ATTR_CONVERTIBLE_BODY);
        if (existing.isPresent()) {
            return (ArgumentBinder.BindingResult)existing.get();
        }
        ArgumentBinder.BindingResult<ConvertibleValues<?>> result = this.bindFullBody(ConversionContext.of(ConvertibleValues.class), nhr);
        nhr.setAttribute(ATTR_CONVERTIBLE_BODY, result);
        return result;
    }

    @Override
    public ArgumentBinder.BindingResult<T> bindFullBody(final ArgumentConversionContext<T> context, HttpRequest<?> source) {
        ImmediateByteBody imm;
        if (!(source instanceof NettyHttpRequest)) {
            return super.bindFullBody(context, source);
        }
        final NettyHttpRequest nhr = (NettyHttpRequest)source;
        ByteBody byteBody = nhr.byteBody();
        if (byteBody instanceof ImmediateByteBody && (imm = (ImmediateByteBody)byteBody).empty()) {
            return ArgumentBinder.BindingResult.empty();
        }
        final ExecutionFlow<ImmediateByteBody> buffered = nhr.byteBody().buffer(nhr.getChannelHandlerContext().alloc());
        return new PendingRequestBindingResult<T>(){
            Optional<T> result;
            {
                nhr.addRouteWaitsFor(buffered.flatMap((? super T imm) -> {
                    try {
                        this.result = NettyBodyAnnotationBinder.this.transform(nhr, context, (ImmediateByteBody)imm);
                        return ExecutionFlow.just(null);
                    }
                    catch (Throwable e) {
                        return ExecutionFlow.error(e);
                    }
                }));
            }

            @Override
            public boolean isPending() {
                return this.result == null;
            }

            @Override
            public Optional<T> getValue() {
                return this.result;
            }

            @Override
            public List<ConversionError> getConversionErrors() {
                return context.getLastError().map(List::of).orElseGet(List::of);
            }
        };
    }

    Optional<T> transform(NettyHttpRequest<?> nhr, ArgumentConversionContext<T> context, ImmediateByteBody imm) throws Throwable {
        if (!DefaultHttpContentProcessorResolver.isRaw(context.getArgument())) {
            MediaType mediaType;
            if (nhr.isFormOrMultipartData()) {
                return imm.processSingle(new FormDataHttpContentProcessor(nhr, this.httpServerConfiguration), this.httpServerConfiguration.getDefaultCharset(), nhr.getChannelHandlerContext().alloc()).convert(this.conversionService, context).map(o -> o.claimForExternal());
            }
            MessageBodyReader reader = null;
            RouteInfo routeInfo = nhr.getAttribute(HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
            if (routeInfo != null) {
                reader = routeInfo.getMessageBodyReader();
            }
            if ((mediaType = (MediaType)nhr.getContentType().orElse(null)) != null) {
                if (reader == null) {
                    reader = this.bodyHandlerRegistry.findReader(context.getArgument(), List.of(mediaType)).orElse(null);
                }
                if (reader != null) {
                    try {
                        return Optional.ofNullable(imm.processSingle(this.httpServerConfiguration, reader, context.getArgument(), mediaType, nhr.getHeaders()).claimForExternal());
                    }
                    catch (CodecException ce) {
                        Throwable throwable = ce.getCause();
                        if (throwable instanceof Exception) {
                            Exception e = (Exception)throwable;
                            context.reject(e);
                        } else {
                            context.reject(ce);
                        }
                        return Optional.empty();
                    }
                }
            }
        }
        return imm.rawContent(this.httpServerConfiguration).convert(this.conversionService, context).map(o -> o.claimForExternal());
    }
}

