/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.value.OptionalMultiValues;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.util.CustomizableSerializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Singleton
final class OptionalMultiValuesSerializer<V>
implements CustomizableSerializer<OptionalMultiValues<V>> {
    private final boolean alwaysSerializeErrorsAsList;

    public OptionalMultiValuesSerializer(SerializationConfiguration jacksonConfiguration) {
        this.alwaysSerializeErrorsAsList = jacksonConfiguration.isAlwaysSerializeErrorsAsList();
    }

    @Override
    public ObjectSerializer<OptionalMultiValues<V>> createSpecific(final Serializer.EncoderContext context, Argument<? extends OptionalMultiValues<V>> type) throws SerdeException {
        boolean alwaysSerializeErrorsAsList = context.getSerializationConfiguration().map(SerializationConfiguration::isAlwaysSerializeErrorsAsList).orElse(this.alwaysSerializeErrorsAsList);
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty(generics)) {
            throw new SerdeException("Cannot serialize raw OptionalMultiValues");
        }
        Object generic2 = generics[0];
        final Argument listGeneric = Argument.listOf(generic2);
        return new ObjectSerializer<OptionalMultiValues<V>>((Argument)generic2, alwaysSerializeErrorsAsList){
            Serializer<Object> listSerializer;
            Serializer<Object> valueSerializer;
            final /* synthetic */ Argument val$generic;
            final /* synthetic */ boolean val$alwaysSerializeErrorsAsList;
            {
                this.val$generic = argument2;
                this.val$alwaysSerializeErrorsAsList = bl;
                this.listSerializer = context.findSerializer(listGeneric).createSpecific(context, listGeneric);
                this.valueSerializer = context.findSerializer(this.val$generic).createSpecific(context, this.val$generic);
            }

            @Override
            public void serializeInto(Encoder encoder, Serializer.EncoderContext context2, Argument<? extends OptionalMultiValues<V>> type, OptionalMultiValues<V> value) throws IOException {
                for (CharSequence key : value) {
                    Optional opt = value.get(key);
                    if (!opt.isPresent()) continue;
                    String fieldName = key.toString();
                    encoder.encodeKey(fieldName);
                    List list = (List)opt.get();
                    if (this.val$alwaysSerializeErrorsAsList) {
                        this.listSerializer.serialize(encoder, context2, listGeneric, list);
                        continue;
                    }
                    if (list.size() == 1) {
                        this.valueSerializer.serialize(encoder, context2, this.val$generic, list.get(0));
                        continue;
                    }
                    this.listSerializer.serialize(encoder, context2, listGeneric, list);
                }
            }

            @Override
            public void serialize(Encoder encoder, Serializer.EncoderContext context2, Argument<? extends OptionalMultiValues<V>> type, OptionalMultiValues<V> value) throws IOException {
                Objects.requireNonNull(value, "Values can't be null");
                Encoder objectEncoder = encoder.encodeObject(type);
                this.serializeInto(encoder, context2, type, value);
                objectEncoder.finishStructure();
            }

            @Override
            public boolean isEmpty(Serializer.EncoderContext context2, OptionalMultiValues<V> value) {
                return value == null || value.isEmpty();
            }
        };
    }
}

