/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.server;

import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.scheduling.annotation.ExecuteOn;
import io.micronaut.testresources.core.ResolverLoader;
import io.micronaut.testresources.core.Scope;
import io.micronaut.testresources.core.TestResourcesResolutionException;
import io.micronaut.testresources.core.TestResourcesResolver;
import io.micronaut.testresources.core.ToggableTestResourcesResolver;
import io.micronaut.testresources.server.Ping;
import io.micronaut.testresources.server.PropertyResolutionListener;
import io.micronaut.testresources.server.TestContainer;
import io.micronaut.testresources.testcontainers.TestContainers;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller(value="/")
@ExecuteOn(value="blocking")
@Ping
public class TestResourcesController
implements TestResourcesResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestResourcesController.class);
    private static final int MAX_STOP_TIMEOUT = 5000;
    private final ResolverLoader loader;
    private final List<PropertyResolutionListener> propertyResolutionListeners;
    private final EmbeddedServer embeddedServer;
    private final ApplicationContext applicationContext;

    public TestResourcesController(List<PropertyResolutionListener> propertyResolutionListeners, EmbeddedServer embeddedServer, ApplicationContext applicationContext, ResolverLoader loader) {
        this.propertyResolutionListeners = propertyResolutionListeners;
        this.embeddedServer = embeddedServer;
        this.applicationContext = applicationContext;
        this.loader = loader;
    }

    @Get(value="/list")
    public List<String> getResolvableProperties() {
        return this.getResolvableProperties(Collections.emptyMap(), Collections.emptyMap());
    }

    @Override
    @Post(value="/list")
    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        return this.loader.getResolvers().stream().filter(testResourcesResolver -> TestResourcesController.isEnabled(testResourcesResolver, testResourcesConfig)).map(r -> r.getResolvableProperties(propertyEntries, testResourcesConfig)).flatMap(Collection::stream).distinct().peek(p -> LOGGER.debug("For configuration {} and property entries {} , resolvable property: {}", testResourcesConfig, propertyEntries, p)).toList();
    }

    @Override
    @Get(value="/requirements/expr/{expression}")
    public List<String> getRequiredProperties(String expression) {
        return this.loader.getResolvers().stream().map(testResourcesResolver -> testResourcesResolver.getRequiredProperties(expression)).flatMap(Collection::stream).distinct().toList();
    }

    @Override
    @Get(value="/requirements/entries")
    public List<String> getRequiredPropertyEntries() {
        return this.loader.getResolvers().stream().map(TestResourcesResolver::getRequiredPropertyEntries).flatMap(Collection::stream).distinct().toList();
    }

    @Override
    @Post(value="/resolve")
    public Optional<String> resolve(String name, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
        Optional<String> result = Optional.empty();
        for (TestResourcesResolver resolver : this.loader.getResolvers()) {
            ToggableTestResourcesResolver toggable;
            if (resolver instanceof ToggableTestResourcesResolver && !(toggable = (ToggableTestResourcesResolver)resolver).isEnabled(testResourcesConfig)) continue;
            try {
                result = resolver.resolve(name, properties, testResourcesConfig);
                LOGGER.debug("Attempt to resolve {} with resolver {}, properties {} and test resources configuration {} : {}", name, resolver.getClass(), properties, testResourcesConfig, result.orElse("\ud83d\udeab"));
            }
            catch (Exception ex) {
                for (PropertyResolutionListener listener : this.propertyResolutionListeners) {
                    listener.errored(name, resolver, ex);
                }
                throw TestResourcesResolutionException.wrap(ex);
            }
            if (!result.isPresent()) continue;
            for (PropertyResolutionListener listener : this.propertyResolutionListeners) {
                listener.resolved(name, result.get(), resolver, properties, testResourcesConfig);
            }
            return result;
        }
        return result;
    }

    @Get(value="/close/all")
    public boolean closeAll() {
        LOGGER.debug("Closing all test resources");
        return TestContainers.closeAll();
    }

    @Get(value="/close/{id}")
    public boolean closeScope(@Nullable String id) {
        LOGGER.info("Closing test resources of scope {}", (Object)id);
        return TestContainers.closeScope(id);
    }

    @Get(value="/testcontainers")
    public List<TestContainer> listContainers() {
        return this.listContainersByScope(null);
    }

    @Get(value="/testcontainers/{scope}")
    public List<TestContainer> listContainersByScope(@Nullable String scope) {
        return TestContainers.listByScope(scope).entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(c -> new TestContainer(c.getContainerName(), c.getDockerImageName(), c.getContainerId(), ((Scope)entry.getKey()).toString()))).toList();
    }

    @Post(value="/stop")
    public void stopService() {
        Thread makeSureServerIsStopped = new Thread(() -> {
            try {
                try {
                    this.embeddedServer.stop();
                    this.applicationContext.close();
                    this.closeResolvers();
                    TestContainers.closeAll();
                }
                finally {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                System.exit(0);
            }
        });
        makeSureServerIsStopped.setDaemon(true);
        makeSureServerIsStopped.start();
    }

    private void closeResolvers() {
        ((Stream)this.loader.getResolvers().stream().parallel()).filter(Closeable.class::isInstance).map(Closeable.class::cast).forEach(closable -> {
            try {
                closable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private static boolean isEnabled(TestResourcesResolver resolver, Map<String, Object> testResourcesConfig) {
        if (resolver instanceof ToggableTestResourcesResolver) {
            ToggableTestResourcesResolver toggable = (ToggableTestResourcesResolver)resolver;
            return toggable.isEnabled(testResourcesConfig);
        }
        return true;
    }
}

