/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@Indexed(value=MessageBodyWriter.class)
public interface MessageBodyWriter<T> {
    default public boolean isWriteable(@NonNull Argument<T> type, @Nullable MediaType mediaType) {
        return true;
    }

    default public MessageBodyWriter<T> createSpecific(@NonNull Argument<T> type) {
        return this;
    }

    default public boolean isBlocking() {
        return false;
    }

    @NonNull
    public static Charset getCharset(@NonNull Headers headers) {
        HttpHeaders httpHeaders;
        Charset charset;
        if (headers instanceof HttpHeaders && (charset = (httpHeaders = (HttpHeaders)headers).acceptCharset()) != null) {
            return charset;
        }
        return StandardCharsets.UTF_8;
    }

    public void writeTo(@NonNull Argument<T> var1, @NonNull MediaType var2, T var3, @NonNull MutableHeaders var4, @NonNull OutputStream var5) throws CodecException;

    @NonNull
    default public ByteBuffer<?> writeTo(@NonNull Argument<T> type, @NonNull MediaType mediaType, T object, @NonNull MutableHeaders outgoingHeaders, @NonNull ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
        ByteBuffer<?> buffer = bufferFactory.buffer();
        try {
            this.writeTo(type, mediaType, object, outgoingHeaders, buffer.toOutputStream());
        }
        catch (Throwable t2) {
            if (buffer instanceof ReferenceCounted) {
                ReferenceCounted rc = (ReferenceCounted)((Object)buffer);
                rc.release();
            }
            throw t2;
        }
        return buffer;
    }
}

