/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.cors;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import java.util.Optional;

@Internal
public final class CorsUtil {
    private CorsUtil() {
    }

    public static boolean isPreflightRequest(HttpRequest<?> request) {
        HttpHeaders headers = request.getHeaders();
        Optional<String> origin = request.getOrigin();
        return origin.isPresent() && HttpMethod.OPTIONS == request.getMethod() && (headers.contains("Access-Control-Request-Method") || headers.contains("Access-Control-Request-Headers") || headers.contains("Access-Control-Request-Private-Network"));
    }
}

