/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.cors;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.cors.CorsOriginConfiguration;
import io.micronaut.http.server.cors.CrossOrigin;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CrossOriginUtil {
    public static final String MEMBER_ALLOWED_ORIGINS = "allowedOrigins";
    public static final String MEMBER_ALLOWED_ORIGINS_REGEX = "allowedOriginsRegex";
    public static final String MEMBER_ALLOWED_HEADERS = "allowedHeaders";
    public static final String MEMBER_EXPOSED_HEADERS = "exposedHeaders";
    public static final String MEMBER_ALLOWED_METHODS = "allowedMethods";
    public static final String MEMBER_ALLOW_CREDENTIALS = "allowCredentials";
    public static final String MEMBER_ALLOW_PRIVATE_NETWORK = "allowPrivateNetwork";
    public static final String MEMBER_MAX_AGE = "maxAge";

    private CrossOriginUtil() {
    }

    @NonNull
    public static Optional<CorsOriginConfiguration> getCorsOriginConfigurationForRequest(@NonNull HttpRequest<?> request) {
        return request.getAttribute(HttpAttributes.ROUTE_MATCH, AnnotationMetadata.class).flatMap(CrossOriginUtil::getCorsOriginConfiguration);
    }

    private static Optional<CorsOriginConfiguration> getCorsOriginConfiguration(@NonNull AnnotationMetadata annotationMetadata) {
        if (!annotationMetadata.hasAnnotation(CrossOrigin.class)) {
            return Optional.empty();
        }
        CorsOriginConfiguration config = new CorsOriginConfiguration();
        String[] allowedOrigins = annotationMetadata.stringValues(CrossOrigin.class, MEMBER_ALLOWED_ORIGINS);
        annotationMetadata.stringValue(CrossOrigin.class, MEMBER_ALLOWED_ORIGINS_REGEX).ifPresentOrElse(regex -> {
            config.setAllowedOriginsRegex((String)regex);
            config.setAllowedOrigins(Arrays.asList(allowedOrigins));
        }, () -> config.setAllowedOrigins(allowedOrigins.length == 0 ? CorsOriginConfiguration.ANY : Arrays.asList(allowedOrigins)));
        String[] allowedHeaders = annotationMetadata.stringValues(CrossOrigin.class, MEMBER_ALLOWED_HEADERS);
        List<String> allowedHeadersList = allowedHeaders.length == 0 ? CorsOriginConfiguration.ANY : Arrays.asList(allowedHeaders);
        config.setAllowedHeaders(allowedHeadersList);
        config.setExposedHeaders(Arrays.asList(annotationMetadata.stringValues(CrossOrigin.class, MEMBER_EXPOSED_HEADERS)));
        List allowedMethods = Stream.of(annotationMetadata.stringValues(CrossOrigin.class, MEMBER_ALLOWED_METHODS)).map(HttpMethod::parse).filter(method -> method != HttpMethod.CUSTOM).collect(Collectors.toList());
        config.setAllowedMethods(CollectionUtils.isNotEmpty(allowedMethods) ? allowedMethods : CorsOriginConfiguration.ANY_METHOD);
        annotationMetadata.booleanValue(CrossOrigin.class, MEMBER_ALLOW_CREDENTIALS).ifPresent(config::setAllowCredentials);
        annotationMetadata.booleanValue(CrossOrigin.class, MEMBER_ALLOW_PRIVATE_NETWORK).ifPresent(config::setAllowPrivateNetwork);
        annotationMetadata.longValue(CrossOrigin.class, MEMBER_MAX_AGE).ifPresent(config::setMaxAge);
        return Optional.of(config);
    }
}

