/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.body.ImmediateByteBody;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class NettyInputStreamBodyBinder
implements NonBlockingBodyArgumentBinder<InputStream> {
    public static final Argument<InputStream> TYPE = Argument.of(InputStream.class);
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private final HttpServerConfiguration httpServerConfiguration;

    NettyInputStreamBodyBinder(HttpServerConfiguration httpServerConfiguration) {
        this.httpServerConfiguration = httpServerConfiguration;
    }

    @Override
    public Argument<InputStream> argumentType() {
        return TYPE;
    }

    @Override
    public ArgumentBinder.BindingResult<InputStream> bind(ArgumentConversionContext<InputStream> context, HttpRequest<?> source) {
        if (source instanceof NettyHttpRequest) {
            ImmediateByteBody imm;
            NettyHttpRequest nhr = (NettyHttpRequest)source;
            ByteBody byteBody = nhr.byteBody();
            if (byteBody instanceof ImmediateByteBody && (imm = (ImmediateByteBody)byteBody).empty()) {
                return ArgumentBinder.BindingResult.empty();
            }
            try {
                InputStream s2 = nhr.byteBody().rawContent(this.httpServerConfiguration).coerceToInputStream(nhr.getChannelHandlerContext().alloc());
                return () -> Optional.of(s2);
            }
            catch (ContentLengthExceededException t2) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Server received error for argument [{}]: {}", context.getArgument(), t2.getMessage(), t2);
                }
                return ArgumentBinder.BindingResult.empty();
            }
        }
        return ArgumentBinder.BindingResult.empty();
    }
}

