/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Internal
final class QueryStringDecoder {
    private static final int DEFAULT_MAX_PARAMS = 1024;
    private final Charset charset;
    private final String uri;
    private final int maxParams;
    private int pathEndIdx;
    private String path;
    private Map<String, List<String>> params;

    QueryStringDecoder(String uri) {
        this(uri, StandardCharsets.UTF_8);
    }

    QueryStringDecoder(String uri, boolean hasPath) {
        this(uri, StandardCharsets.UTF_8, hasPath);
    }

    QueryStringDecoder(String uri, Charset charset) {
        this(uri, charset, true);
    }

    QueryStringDecoder(String uri, Charset charset, boolean hasPath) {
        this(uri, charset, hasPath, 1024);
    }

    QueryStringDecoder(String uri, Charset charset, boolean hasPath, int maxParams) {
        this.uri = Objects.requireNonNull(uri, "uri");
        this.charset = Objects.requireNonNull(charset, "charset");
        this.maxParams = Objects.requireNonNull(Integer.valueOf(maxParams), "maxParams");
        this.pathEndIdx = hasPath ? -1 : 0;
    }

    QueryStringDecoder(URI uri) {
        this(uri, StandardCharsets.UTF_8);
    }

    QueryStringDecoder(URI uri, Charset charset) {
        this(uri, charset, 1024);
    }

    QueryStringDecoder(URI uri, Charset charset, int maxParams) {
        String rawQuery;
        String rawPath = uri.getRawPath();
        if (rawPath == null) {
            rawPath = "";
        }
        this.uri = (rawQuery = uri.getRawQuery()) == null ? rawPath : rawPath + "?" + rawQuery;
        this.charset = Objects.requireNonNull(charset, "charset");
        this.maxParams = ArgumentUtils.requirePositive("maxParams", maxParams);
        this.pathEndIdx = rawPath.length();
    }

    public String toString() {
        return this.uri();
    }

    public String uri() {
        return this.uri;
    }

    public String path() {
        if (this.path == null) {
            this.path = QueryStringDecoder.decodeComponent(this.uri, 0, this.pathEndIdx(), this.charset, true);
        }
        return this.path;
    }

    public Map<String, List<String>> parameters() {
        if (this.params == null) {
            this.params = QueryStringDecoder.decodeParams(this.uri, this.pathEndIdx(), this.charset, this.maxParams);
        }
        return this.params;
    }

    public String rawPath() {
        return this.uri.substring(0, this.pathEndIdx());
    }

    public String rawQuery() {
        int start = this.pathEndIdx() + 1;
        return start < this.uri.length() ? this.uri.substring(start) : "";
    }

    private int pathEndIdx() {
        if (this.pathEndIdx == -1) {
            this.pathEndIdx = QueryStringDecoder.findPathEndIndex(this.uri);
        }
        return this.pathEndIdx;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Map<String, List<String>> decodeParams(String s2, int from, Charset charset, int paramsLimit) {
        int i;
        int len = s2.length();
        if (from >= len) {
            return Collections.emptyMap();
        }
        if (s2.charAt(from) == '?') {
            ++from;
        }
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        int nameStart = from;
        int valueStart = -1;
        block5: for (i = from; i < len; ++i) {
            switch (s2.charAt(i)) {
                case '=': {
                    if (nameStart == i) {
                        nameStart = i + 1;
                        break;
                    }
                    if (valueStart >= nameStart) break;
                    valueStart = i + 1;
                    break;
                }
                case '&': 
                case ';': {
                    if (QueryStringDecoder.addParam(s2, nameStart, valueStart, i, params, charset) && --paramsLimit == 0) {
                        return params;
                    }
                    nameStart = i + 1;
                    break;
                }
                case '#': {
                    break block5;
                }
            }
        }
        QueryStringDecoder.addParam(s2, nameStart, valueStart, i, params, charset);
        return params;
    }

    public static String decodeComponent(String s2) {
        return QueryStringDecoder.decodeComponent(s2, StandardCharsets.UTF_8);
    }

    private static String decodeComponent(String s2, Charset charset) {
        if (s2 == null) {
            return "";
        }
        return QueryStringDecoder.decodeComponent(s2, 0, s2.length(), charset, false);
    }

    private static boolean addParam(String s2, int nameStart, int valueStart, int valueEnd, Map<String, List<String>> params, Charset charset) {
        if (nameStart >= valueEnd) {
            return false;
        }
        if (valueStart <= nameStart) {
            valueStart = valueEnd + 1;
        }
        String name = QueryStringDecoder.decodeComponent(s2, nameStart, valueStart - 1, charset, false);
        String value = QueryStringDecoder.decodeComponent(s2, valueStart, valueEnd, charset, false);
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
        return true;
    }

    private static String decodeComponent(String s2, int from, int toExcluded, Charset charset, boolean isPath) {
        int len = toExcluded - from;
        if (len <= 0) {
            return "";
        }
        int firstEscaped = -1;
        for (int i = from; i < toExcluded; ++i) {
            char c = s2.charAt(i);
            if (c != '%' && (c != '+' || isPath)) continue;
            firstEscaped = i;
            break;
        }
        if (firstEscaped == -1) {
            return s2.substring(from, toExcluded);
        }
        CharsetDecoder decoder = charset.newDecoder();
        int decodedCapacity = (toExcluded - firstEscaped) / 3;
        ByteBuffer byteBuf = ByteBuffer.allocate(decodedCapacity);
        CharBuffer charBuf = CharBuffer.allocate(decodedCapacity);
        StringBuilder strBuf = new StringBuilder(len);
        strBuf.append(s2, from, firstEscaped);
        for (int i = firstEscaped; i < toExcluded; ++i) {
            char c = s2.charAt(i);
            if (c != '%') {
                strBuf.append(c != '+' || isPath ? c : (char)' ');
                continue;
            }
            byteBuf.clear();
            do {
                if (i + 3 > toExcluded) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i + " of: " + s2);
                }
                byteBuf.put(QueryStringDecoder.decodeHexByte(s2, i + 1));
            } while ((i += 3) < toExcluded && s2.charAt(i) == '%');
            --i;
            byteBuf.flip();
            charBuf.clear();
            CoderResult result = decoder.reset().decode(byteBuf, charBuf, true);
            try {
                if (!result.isUnderflow()) {
                    result.throwException();
                }
                if (!(result = decoder.flush(charBuf)).isUnderflow()) {
                    result.throwException();
                }
            }
            catch (CharacterCodingException ex) {
                throw new IllegalStateException(ex);
            }
            strBuf.append(charBuf.flip());
        }
        return strBuf.toString();
    }

    private static int findPathEndIndex(String uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c != '?' && c != '#') continue;
            return i;
        }
        return len;
    }

    private static byte decodeHexByte(CharSequence s2, int pos) {
        int hi = QueryStringDecoder.decodeHexNibble(s2.charAt(pos));
        int lo = QueryStringDecoder.decodeHexNibble(s2.charAt(pos + 1));
        if (hi == -1 || lo == -1) {
            throw new IllegalArgumentException("invalid hex byte '%s' at index %d of '%s'".formatted(s2.subSequence(pos, pos + 2), pos, s2));
        }
        return (byte)((hi << 4) + lo);
    }

    private static int decodeHexNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }
}

