/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.bind;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.BeanPropertyBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.json.JsonConfiguration;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.bind.JsonBeanPropertyBinderExceptionHandler;
import io.micronaut.json.tree.JsonNode;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Internal
@Singleton
@Primary
final class JsonBeanPropertyBinder
implements BeanPropertyBinder {
    private final JsonMapper jsonMapper;
    private final int arraySizeThreshold;
    private final BeanProvider<JsonBeanPropertyBinderExceptionHandler> exceptionHandlers;

    JsonBeanPropertyBinder(JsonMapper jsonMapper, JsonConfiguration configuration, BeanProvider<JsonBeanPropertyBinderExceptionHandler> exceptionHandlers) {
        this.jsonMapper = jsonMapper;
        this.arraySizeThreshold = configuration.getArraySizeThreshold();
        this.exceptionHandlers = exceptionHandlers;
    }

    @Override
    public ArgumentBinder.BindingResult<Object> bind(final ArgumentConversionContext<Object> context, Map<CharSequence, ? super Object> source) {
        try {
            JsonNode objectNode = this.buildSourceObjectNode(source.entrySet());
            Object result = this.jsonMapper.readValueFromTree(objectNode, context.getArgument());
            return () -> Optional.of(result);
        }
        catch (Exception e) {
            context.reject(e);
            return new ArgumentBinder.BindingResult<Object>(){

                @Override
                public List<ConversionError> getConversionErrors() {
                    return CollectionUtils.iterableToList(context);
                }

                @Override
                public boolean isSatisfied() {
                    return false;
                }

                @Override
                public Optional<Object> getValue() {
                    return Optional.empty();
                }
            };
        }
    }

    @Override
    public <T2> T2 bind(Class<T2> type, Set<? extends Map.Entry<? extends CharSequence, Object>> source) throws ConversionErrorException {
        try {
            JsonNode objectNode = this.buildSourceObjectNode(source);
            return this.jsonMapper.readValueFromTree(objectNode, type);
        }
        catch (Exception e) {
            throw this.newConversionError(null, e);
        }
    }

    @Override
    public <T2> T2 bind(T2 object, ArgumentConversionContext<T2> context, Set<? extends Map.Entry<? extends CharSequence, Object>> source) {
        try {
            JsonNode objectNode = this.buildSourceObjectNode(source);
            this.jsonMapper.updateValueFromTree(object, objectNode);
        }
        catch (Exception e) {
            context.reject(e);
        }
        return object;
    }

    @Override
    public <T2> T2 bind(T2 object, Set<? extends Map.Entry<? extends CharSequence, Object>> source) throws ConversionErrorException {
        try {
            JsonNode objectNode = this.buildSourceObjectNode(source);
            this.jsonMapper.updateValueFromTree(object, objectNode);
        }
        catch (Exception e) {
            throw this.newConversionError(object, e);
        }
        return object;
    }

    private ConversionErrorException newConversionError(Object object, Exception e) {
        for (JsonBeanPropertyBinderExceptionHandler exceptionHandler : this.exceptionHandlers) {
            Optional<ConversionErrorException> handled = exceptionHandler.toConversionError(object, e);
            if (!handled.isPresent()) continue;
            return handled.get();
        }
        Class type = object != null ? object.getClass() : Object.class;
        return new ConversionErrorException(Argument.of(type), e);
    }

    private JsonNode buildSourceObjectNode(Set<? extends Map.Entry<? extends CharSequence, Object>> source) throws IOException {
        ObjectBuilder rootNode = new ObjectBuilder();
        for (Map.Entry<? extends CharSequence, Object> entry : source) {
            CharSequence key = entry.getKey();
            Object value = entry.getValue();
            String property = key.toString();
            ObjectBuilder current = rootNode;
            String index = null;
            Iterator<String> tokenIterator = StringUtils.splitOmitEmptyStringsIterator(property, '.');
            while (tokenIterator.hasNext()) {
                String token = tokenIterator.next();
                int j = token.indexOf(91);
                if (j > -1 && token.endsWith("]")) {
                    index = token.substring(j + 1, token.length() - 1);
                    token = token.substring(0, j);
                }
                if (!tokenIterator.hasNext()) {
                    if (index != null) {
                        current = this.getOrCreateObjectAtKey(current, index);
                    }
                    JsonNode valueNode = this.jsonMapper.writeValueToTree(value);
                    if (current == rootNode && valueNode.isValueNode()) {
                        ArrayBuilder array = new ArrayBuilder();
                        array.values.add(new FixedValue(valueNode));
                        current.values.put(token, array);
                        continue;
                    }
                    current.values.put(token, new FixedValue(valueNode));
                    continue;
                }
                if (index != null) {
                    if (StringUtils.isDigits(index)) {
                        ArrayBuilder arrayNode = this.getOrCreateArrayAtKey(current, token);
                        int arrayIndex = Integer.parseInt(index);
                        this.expandArrayToThreshold(arrayIndex, arrayNode);
                        current = this.getOrCreateNodeAtIndex(arrayNode, arrayIndex);
                    } else {
                        ObjectBuilder objectNode = this.getOrCreateObjectAtKey(current, token);
                        current = this.getOrCreateObjectAtKey(objectNode, index);
                    }
                    index = null;
                    continue;
                }
                current = this.getOrCreateObjectAtKey(current, token);
            }
        }
        return rootNode.build();
    }

    private ObjectBuilder getOrCreateObjectAtKey(ObjectBuilder objectNode, String key) {
        ValueBuilder valueBuilder = objectNode.values.get(key);
        if (valueBuilder instanceof ObjectBuilder) {
            ObjectBuilder objectBuilder = (ObjectBuilder)valueBuilder;
            return objectBuilder;
        }
        ObjectBuilder objectBuilder = new ObjectBuilder();
        objectNode.values.put(key, objectBuilder);
        return objectBuilder;
    }

    private ArrayBuilder getOrCreateArrayAtKey(ObjectBuilder objectNode, String key) {
        ValueBuilder valueBuilder = objectNode.values.get(key);
        if (valueBuilder instanceof ArrayBuilder) {
            ArrayBuilder arrayBuilder = (ArrayBuilder)valueBuilder;
            return arrayBuilder;
        }
        ArrayBuilder arrayBuilder = new ArrayBuilder();
        objectNode.values.put(key, arrayBuilder);
        return arrayBuilder;
    }

    private ObjectBuilder getOrCreateNodeAtIndex(ArrayBuilder arrayNode, int arrayIndex) {
        ValueBuilder jsonNode = arrayNode.values.get(arrayIndex);
        if (jsonNode instanceof ObjectBuilder) {
            ObjectBuilder objectBuilder = (ObjectBuilder)jsonNode;
            return objectBuilder;
        }
        ObjectBuilder objectBuilder = new ObjectBuilder();
        arrayNode.values.set(arrayIndex, objectBuilder);
        return objectBuilder;
    }

    private void expandArrayToThreshold(int arrayIndex, ArrayBuilder arrayNode) {
        if (arrayIndex < this.arraySizeThreshold) {
            while (arrayNode.values.size() != arrayIndex + 1) {
                arrayNode.values.add(FixedValue.NULL);
            }
        }
    }

    private static final class ObjectBuilder
    implements ValueBuilder {
        final Map<String, ValueBuilder> values = new LinkedHashMap<String, ValueBuilder>();

        private ObjectBuilder() {
        }

        @Override
        public JsonNode build() {
            LinkedHashMap<String, JsonNode> built = CollectionUtils.newLinkedHashMap(this.values.size());
            for (Map.Entry<String, ValueBuilder> entry : this.values.entrySet()) {
                built.put(entry.getKey(), entry.getValue().build());
            }
            return JsonNode.createObjectNode(built);
        }
    }

    private static final class ArrayBuilder
    implements ValueBuilder {
        final List<ValueBuilder> values = new ArrayList<ValueBuilder>();

        private ArrayBuilder() {
        }

        @Override
        public JsonNode build() {
            return JsonNode.createArrayNode(this.values.stream().map(ValueBuilder::build).toList());
        }
    }

    private static final class FixedValue
    implements ValueBuilder {
        static final FixedValue NULL = new FixedValue(JsonNode.nullNode());
        final JsonNode value;

        FixedValue(JsonNode value) {
            this.value = value;
        }

        @Override
        public JsonNode build() {
            return this.value;
        }
    }

    private static interface ValueBuilder {
        public JsonNode build();
    }
}

