/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.config.naming;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import java.util.StringTokenizer;

public class UpperCamelCaseStrategyWithSpaces
implements PropertyNamingStrategy {
    @Override
    public String translate(AnnotatedElement element) {
        String name = element.getName();
        if (StringUtils.isNotEmpty(name)) {
            StringTokenizer t2 = new StringTokenizer(NameUtils.hyphenate(name), "-", false);
            StringBuilder builder = new StringBuilder();
            while (t2.hasMoreTokens()) {
                String token = t2.nextToken();
                builder.append(NameUtils.capitalize(token));
                if (!t2.hasMoreTokens()) continue;
                builder.append(' ');
            }
            return builder.toString();
        }
        return name;
    }
}

