/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Serde;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.DeserializationConfiguration;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.DefaultDecoderContext;
import io.micronaut.serde.support.DefaultEncoderContext;
import io.micronaut.serde.support.DeserializerRegistrar;
import io.micronaut.serde.support.LegacyBeansFactory;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.SerializerRegistrar;
import io.micronaut.serde.support.deserializers.ObjectDeserializer;
import io.micronaut.serde.support.deserializers.SerdeDeserializationPreInstantiateCallback;
import io.micronaut.serde.support.deserializers.collect.CoreCollectionsDeserializers;
import io.micronaut.serde.support.serdes.ObjectArraySerde;
import io.micronaut.serde.support.serdes.Serdes;
import io.micronaut.serde.support.serializers.CoreSerializers;
import io.micronaut.serde.support.serializers.ObjectSerializer;
import io.micronaut.serde.support.util.MatchArgumentQualifier;
import io.micronaut.serde.support.util.TypeKey;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
@BootstrapContextCompatible
public class DefaultSerdeRegistry
implements SerdeRegistry {
    @Deprecated(since="2.9.0")
    public static final Serde<Integer> INTEGER_SERDE = Serdes.INTEGER_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<Long> LONG_SERDE = Serdes.LONG_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<Short> SHORT_SERDE = Serdes.SHORT_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<Float> FLOAT_SERDE = Serdes.FLOAT_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<Byte> BYTE_SERDE = Serdes.BYTE_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<Double> DOUBLE_SERDE = Serdes.DOUBLE_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<OptionalInt> OPTIONAL_INT_SERDE = Serdes.OPTIONAL_INT_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<OptionalDouble> OPTIONAL_DOUBLE_SERDE = Serdes.OPTIONAL_DOUBLE_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<OptionalLong> OPTIONAL_LONG_SERDE = Serdes.OPTIONAL_LONG_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<BigDecimal> BIG_DECIMAL_SERDE = Serdes.BIG_DECIMAL_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<BigInteger> BIG_INTEGER_SERDE = Serdes.BIG_INTEGER_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<UUID> UUID_SERDE = Serdes.UUID_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<URL> URL_SERDE = Serdes.URL_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<URI> URI_SERDE = Serdes.URI_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<Charset> CHARSET_SERDE = Serdes.CHARSET_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<TimeZone> TIME_ZONE_SERDE = Serdes.TIME_ZONE_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<Locale> LOCALE_SERDE = Serdes.LOCALE_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<int[]> INT_ARRAY_SERDE = Serdes.INT_ARRAY_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<long[]> LONG_ARRAY_SERDE = Serdes.LONG_ARRAY_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<float[]> FLOAT_ARRAY_SERDE = Serdes.FLOAT_ARRAY_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<short[]> SHORT_ARRAY_SERDE = Serdes.SHORT_ARRAY_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<double[]> DOUBLE_ARRAY_SERDE = Serdes.DOUBLE_ARRAY_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<boolean[]> BOOLEAN_ARRAY_SERDE = Serdes.BOOLEAN_ARRAY_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<byte[]> BYTE_ARRAY_SERDE = Serdes.BYTE_ARRAY_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<char[]> CHAR_ARRAY_SERDE = Serdes.CHAR_ARRAY_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<String> STRING_SERDE = Serdes.STRING_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<Boolean> BOOLEAN_SERDE = Serdes.BOOLEAN_SERDE;
    @Deprecated(since="2.9.0")
    public static final Serde<Charset> CHAR_SERDE = Serdes.CHARSET_SERDE;
    @Deprecated(since="2.9.0")
    public static final List<SerdeRegistrar<?>> DEFAULT_SERDES = Serdes.LEGACY_DEFAULT_SERDES;
    private final List<BeanDefinition<Serializer>> serializers = new ArrayList<BeanDefinition<Serializer>>(100);
    private final List<BeanDefinition<Deserializer>> deserializers = new ArrayList<BeanDefinition<Deserializer>>(100);
    private final List<BeanDefinition<Serde>> internalSerdes = new ArrayList<BeanDefinition<Serde>>(100);
    private final Map<TypeKey, Serializer<?>> serializerMap = new ConcurrentHashMap(50);
    private final Map<TypeKey, Deserializer<?>> deserializerMap = new ConcurrentHashMap(50);
    private final BeanContext beanContext;
    private final SerdeIntrospections introspections;
    private final ObjectSerializer objectSerializer;
    private final ObjectDeserializer objectDeserializer;
    private final Serde<Object[]> objectArraySerde;
    private final ConversionService conversionService;
    private final SerdeConfiguration serdeConfiguration;
    private final SerializationConfiguration serializationConfiguration;
    private final DeserializationConfiguration deserializationConfiguration;

    @Deprecated(forRemoval=true, since="2.9.0")
    public DefaultSerdeRegistry(BeanContext beanContext, ObjectSerializer objectSerializer, ObjectDeserializer objectDeserializer, Serde<Object[]> objectArraySerde, SerdeIntrospections introspections, ConversionService conversionService, SerdeConfiguration serdeConfiguration, SerializationConfiguration serializationConfiguration, DeserializationConfiguration deserializationConfiguration) {
        this.serdeConfiguration = serdeConfiguration;
        this.serializationConfiguration = serializationConfiguration;
        this.deserializationConfiguration = deserializationConfiguration;
        this.introspections = introspections;
        this.objectArraySerde = objectArraySerde;
        this.beanContext = beanContext;
        this.conversionService = conversionService;
        this.registerSerializersDeserializersFromBeanContext(beanContext);
        this.registerBuiltInSerdes();
        this.objectSerializer = objectSerializer;
        this.objectDeserializer = objectDeserializer;
    }

    @Inject
    public DefaultSerdeRegistry(@Nullable BeanContext beanContext, SerdeIntrospections introspections, ConversionService conversionService, SerdeConfiguration serdeConfiguration, SerializationConfiguration serializationConfiguration, DeserializationConfiguration deserializationConfiguration) {
        this.serdeConfiguration = serdeConfiguration;
        this.serializationConfiguration = serializationConfiguration;
        this.deserializationConfiguration = deserializationConfiguration;
        this.introspections = introspections;
        this.beanContext = beanContext;
        this.conversionService = conversionService;
        this.registerSerializersDeserializersFromBeanContext(beanContext);
        this.registerBuiltInSerdes();
        this.objectSerializer = new ObjectSerializer(introspections, serdeConfiguration, serializationConfiguration, beanContext);
        this.objectDeserializer = new ObjectDeserializer(introspections, deserializationConfiguration, serdeConfiguration, beanContext == null ? null : (SerdeDeserializationPreInstantiateCallback)beanContext.findBean(SerdeDeserializationPreInstantiateCallback.class).orElse(null));
        this.objectArraySerde = new ObjectArraySerde();
    }

    @Deprecated
    public DefaultSerdeRegistry(BeanContext beanContext, ObjectSerializer objectSerializer, ObjectDeserializer objectDeserializer, Serde<Object[]> objectArraySerde, SerdeIntrospections introspections, ConversionService conversionService) {
        this(beanContext, objectSerializer, objectDeserializer, objectArraySerde, introspections, conversionService, beanContext.getBean(SerdeConfiguration.class), beanContext.getBean(SerializationConfiguration.class), beanContext.getBean(DeserializationConfiguration.class));
    }

    private void registerSerializersDeserializersFromBeanContext(@Nullable BeanContext beanContext) {
        Argument<Object> argument;
        List<Argument<Object>> typeArguments;
        if (beanContext == null) {
            return;
        }
        for (BeanDefinition<Serializer> beanDefinition : beanContext.getBeanDefinitions(Serializer.class)) {
            if (beanDefinition.getDeclaringType().orElse(null) == LegacyBeansFactory.class) continue;
            typeArguments = beanDefinition.getTypeArguments(Serializer.class);
            if (CollectionUtils.isEmpty(typeArguments)) {
                throw new ConfigurationException("Serializer without generic types defined: " + beanDefinition.getBeanType());
            }
            argument = typeArguments.iterator().next();
            if (argument.equalsType(Argument.OBJECT_ARGUMENT)) continue;
            this.serializers.add(beanDefinition);
        }
        for (BeanDefinition<Object> beanDefinition : beanContext.getBeanDefinitions(Deserializer.class)) {
            if (beanDefinition.getDeclaringType().orElse(null) == LegacyBeansFactory.class) continue;
            typeArguments = beanDefinition.getTypeArguments(Deserializer.class);
            if (CollectionUtils.isEmpty(typeArguments)) {
                throw new ConfigurationException("Deserializer without generic types defined: " + beanDefinition.getBeanType());
            }
            argument = typeArguments.iterator().next();
            if (argument.equalsType(Argument.OBJECT_ARGUMENT)) continue;
            this.deserializers.add(beanDefinition);
        }
    }

    @Override
    public SerdeRegistry cloneWithConfiguration(@Nullable SerdeConfiguration configuration, @Nullable SerializationConfiguration serializationConfiguration, @Nullable DeserializationConfiguration deserializationConfiguration) {
        return new DefaultSerdeRegistry(this.beanContext, this.introspections, this.conversionService, configuration == null ? this.serdeConfiguration : configuration, serializationConfiguration == null ? this.serializationConfiguration : serializationConfiguration, deserializationConfiguration == null ? this.deserializationConfiguration : deserializationConfiguration);
    }

    @Nullable
    @Internal
    public <T> Serde<T> findInternalSerde(Argument<T> type) {
        for (BeanDefinition<Serde> serdeBeanDefinition : this.internalSerdes) {
            if (!(serdeBeanDefinition instanceof InternalSerdeBeanDefinition)) continue;
            InternalSerdeBeanDefinition internalSerdeBeanDefinition = (InternalSerdeBeanDefinition)serdeBeanDefinition;
            if (!internalSerdeBeanDefinition.typeArgument.isAssignableFrom(type)) continue;
            return (Serde)internalSerdeBeanDefinition.value;
        }
        return null;
    }

    private void registerBuiltInSerdes() {
        Serdes.register(this.serdeConfiguration, this.introspections, serdeRegistrar -> {
            for (Argument<?> type : serdeRegistrar.getTypes()) {
                this.deserializers.add(new InternalSerdeBeanDefinition<SerdeRegistrar>(type, (Class<SerdeRegistrar>)Deserializer.class, (SerdeRegistrar)serdeRegistrar, serdeRegistrar.getOrder()));
                this.serializers.add(new InternalSerdeBeanDefinition<SerdeRegistrar>(type, (Class<SerdeRegistrar>)Serializer.class, (SerdeRegistrar)serdeRegistrar, serdeRegistrar.getOrder()));
                this.internalSerdes.add(new InternalSerdeBeanDefinition<SerdeRegistrar>(type, (Class<SerdeRegistrar>)Serde.class, (SerdeRegistrar)serdeRegistrar, serdeRegistrar.getOrder()));
            }
        });
        CoreCollectionsDeserializers.register(this.conversionService, deserializerRegistrar -> {
            for (Argument<?> type : deserializerRegistrar.getTypes()) {
                this.deserializers.add(new InternalSerdeBeanDefinition<DeserializerRegistrar>(type, (Class<DeserializerRegistrar>)Deserializer.class, (DeserializerRegistrar)deserializerRegistrar, deserializerRegistrar.getOrder()));
            }
        });
        CoreSerializers.register(this.serializationConfiguration, serializerRegistrar -> {
            for (Argument<?> type : serializerRegistrar.getTypes()) {
                this.serializers.add(new InternalSerdeBeanDefinition<SerializerRegistrar>(type, (Class<SerializerRegistrar>)Serializer.class, (SerializerRegistrar)serializerRegistrar, serializerRegistrar.getOrder()));
            }
        });
    }

    @Override
    public <T, D extends Serializer<? extends T>> D findCustomSerializer(Class<? extends D> serializerClass) throws SerdeException {
        this.checkBeanContext();
        return (D)((Serializer)this.beanContext.findBean(serializerClass).orElseThrow(() -> new SerdeException("Cannot find serializer: " + serializerClass)));
    }

    @Override
    public <T, D extends Deserializer<? extends T>> D findCustomDeserializer(Class<? extends D> deserializerClass) throws SerdeException {
        this.checkBeanContext();
        return (D)((Deserializer)this.beanContext.findBean(deserializerClass).orElseThrow(() -> new SerdeException("Cannot find deserializer: " + deserializerClass)));
    }

    @Override
    public <D extends PropertyNamingStrategy> D findNamingStrategy(Class<? extends D> namingStrategyClass) throws SerdeException {
        this.checkBeanContext();
        return (D)((PropertyNamingStrategy)this.beanContext.findBean(namingStrategyClass).orElseThrow(() -> new SerdeException("Cannot find naming strategy: " + namingStrategyClass)));
    }

    private void checkBeanContext() throws SerdeException {
        if (this.beanContext == null) {
            throw new SerdeException("No bean context present!");
        }
    }

    @Override
    public <T> Deserializer<? extends T> findDeserializer(Argument<? extends T> type) throws SerdeException {
        Objects.requireNonNull(type, "Type cannot be null");
        TypeKey key = new TypeKey(type);
        Deserializer<?> deserializer = this.deserializerMap.get(key);
        if (deserializer != null) {
            return deserializer;
        }
        if (type.getType().equals(Object.class)) {
            return this.objectDeserializer;
        }
        if (type.getType().equals(Object[].class)) {
            return this.objectArraySerde;
        }
        Collection<BeanDefinition<Deserializer>> beanDefinitions = MatchArgumentQualifier.ofSuperVariable(Deserializer.class, type).filter(Deserializer.class, this.deserializers);
        Deserializer deser = null;
        if (beanDefinitions.size() == 1) {
            deser = this.getBean(beanDefinitions.iterator().next());
        } else if (!beanDefinitions.isEmpty()) {
            deser = this.getBean(this.lastChanceResolveDeserializer(type, beanDefinitions));
        }
        if (deser != null) {
            this.deserializerMap.put(key, deser);
            return deser;
        }
        if (key.getType().isArray()) {
            this.deserializerMap.put(key, this.objectArraySerde);
            return this.objectArraySerde;
        }
        this.deserializerMap.put(key, this.objectDeserializer);
        return this.objectDeserializer;
    }

    private <T> T getBean(BeanDefinition<T> definition) {
        if (definition instanceof InternalSerdeBeanDefinition) {
            InternalSerdeBeanDefinition internalSerdeBeanDefinition = (InternalSerdeBeanDefinition)definition;
            return internalSerdeBeanDefinition.value;
        }
        return this.beanContext.getBean(definition);
    }

    @Override
    public <T> Collection<BeanIntrospection<? extends T>> getDeserializableSubtypes(Class<T> superType) {
        return this.introspections.findSubtypeDeserializables(superType);
    }

    @Override
    public <T> Serializer<? super T> findSerializer(Argument<? extends T> type) throws SerdeException {
        Objects.requireNonNull(type, "Type cannot be null");
        TypeKey key = new TypeKey(type);
        Serializer<?> serializer = this.serializerMap.get(key);
        if (serializer != null) {
            return serializer;
        }
        if (type.getType().equals(Object.class)) {
            return this.objectSerializer;
        }
        if (type.getType().equals(Object[].class)) {
            return this.objectArraySerde;
        }
        Collection<BeanDefinition<Serializer>> beanDefinitions = MatchArgumentQualifier.ofExtendsVariable(Serializer.class, type).filter(Serializer.class, this.serializers);
        Serializer ser = null;
        if (beanDefinitions.size() == 1) {
            ser = this.getBean(beanDefinitions.iterator().next());
        } else if (!beanDefinitions.isEmpty()) {
            BeanDefinition<Serializer> definition = this.lastChanceResolveSerializer(type, beanDefinitions);
            ser = this.getBean(definition);
        }
        if (ser != null) {
            this.serializerMap.put(key, ser);
            return ser;
        }
        if (key.getType().isArray()) {
            this.serializerMap.put(key, this.objectArraySerde);
            return this.objectArraySerde;
        }
        this.serializerMap.put(key, this.objectSerializer);
        return this.objectSerializer;
    }

    @NonNull
    private <T> BeanDefinition<T> lastChanceResolve(Argument<?> type, Collection<BeanDefinition<T>> candidates, String beansResolved) throws SerdeException {
        List<BeanDefinition> primary;
        if (candidates.size() > 1 && !(primary = candidates.stream().filter(BeanType::isPrimary).toList()).isEmpty()) {
            candidates = primary;
        }
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        if ((candidates = candidates.stream().filter(candidate -> !candidate.hasDeclaredStereotype((Class<? extends Annotation>)Secondary.class)).toList()).size() == 1) {
            return candidates.iterator().next();
        }
        Iterator i = candidates.stream().sorted((bean1, bean2) -> {
            int order1 = OrderUtil.getOrder(bean1.getAnnotationMetadata());
            int order2 = OrderUtil.getOrder(bean2.getAnnotationMetadata());
            return Integer.compare(order1, order2);
        }).iterator();
        if (i.hasNext()) {
            BeanDefinition bean = (BeanDefinition)i.next();
            if (i.hasNext()) {
                BeanDefinition next = (BeanDefinition)i.next();
                if (OrderUtil.getOrder(bean.getAnnotationMetadata()) == OrderUtil.getOrder(next.getAnnotationMetadata())) {
                    throw new SerdeException("Multiple possible " + beansResolved + " found for type [" + type + "]: " + candidates);
                }
            }
            return bean;
        }
        throw new SerdeException("Multiple possible " + beansResolved + " found for type [" + type + "]: " + candidates);
    }

    private BeanDefinition<Serializer> lastChanceResolveSerializer(Argument<?> type, Collection<BeanDefinition<Serializer>> candidates) throws SerdeException {
        return this.lastChanceResolve(type, candidates, "serializers");
    }

    private BeanDefinition<Deserializer> lastChanceResolveDeserializer(Argument<?> type, Collection<BeanDefinition<Deserializer>> candidates) throws SerdeException {
        return this.lastChanceResolve(type, candidates, "deserializers");
    }

    @Override
    public Serializer.EncoderContext newEncoderContext(final Class<?> view) {
        if (view != null) {
            return new DefaultEncoderContext(this){

                @Override
                public boolean hasView(Class<?> ... views) {
                    if (view == Object.class) {
                        return true;
                    }
                    for (Class<?> candidate : views) {
                        if (!candidate.isAssignableFrom(view)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return new DefaultEncoderContext(this);
    }

    @Override
    public Deserializer.DecoderContext newDecoderContext(final Class<?> view) {
        if (view != null) {
            return new DefaultDecoderContext(this){

                @Override
                public boolean hasView(Class<?> ... views) {
                    if (view == Object.class) {
                        return true;
                    }
                    for (Class<?> candidate : views) {
                        if (!candidate.isAssignableFrom(view)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return new DefaultDecoderContext(this);
    }

    @Override
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @Internal
    public final SerdeConfiguration getSerdeConfiguration() {
        return this.serdeConfiguration;
    }

    @Internal
    final SerializationConfiguration getSerializationConfiguration() {
        return this.serializationConfiguration;
    }

    @Internal
    final DeserializationConfiguration getDeserializationConfiguration() {
        return this.deserializationConfiguration;
    }

    private static final class InternalSerdeBeanDefinition<T>
    implements BeanDefinition<T> {
        private final Argument<?> argument;
        private final Argument<?> typeArgument;
        private final T value;
        private final List<Argument<?>> typeParameters;
        private final AnnotationMetadata annotationMetadata;

        private InternalSerdeBeanDefinition(Argument<?> typeArgument, Class<T> container, T value, int order) {
            this.argument = Argument.of(container, typeArgument);
            this.value = value;
            this.typeArgument = typeArgument;
            this.typeParameters = List.of(this.argument.getTypeParameters());
            if (order == 0) {
                order = 10;
            }
            MutableAnnotationMetadata mutableAnnotationMetadata = new MutableAnnotationMetadata();
            mutableAnnotationMetadata.addAnnotation(Order.class.getName(), Map.of("value", order));
            this.annotationMetadata = mutableAnnotationMetadata;
        }

        @Override
        public AnnotationMetadata getAnnotationMetadata() {
            return this.annotationMetadata;
        }

        @Override
        @NonNull
        public Argument<T> asArgument() {
            return this.argument;
        }

        @Override
        @NonNull
        public List<Argument<?>> getTypeArguments() {
            return this.typeParameters;
        }

        @Override
        @NonNull
        public List<Argument<?>> getTypeArguments(Class<?> type) {
            if (type == Serializer.class || type == Deserializer.class) {
                return this.typeParameters;
            }
            return List.of();
        }

        @Override
        public Class<T> getBeanType() {
            return Serde.class;
        }

        @Override
        public boolean isEnabled(@NonNull BeanContext context, @Nullable BeanResolutionContext resolutionContext) {
            return true;
        }

        public String toString() {
            return this.argument.getTypeName();
        }
    }
}

