/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.EnumCreatorDeserializer;
import java.io.IOException;
import java.util.Locale;

final class EnumSerde<E extends Enum<E>>
implements SerdeRegistrar<E> {
    private final SerdeIntrospections introspections;

    EnumSerde(SerdeIntrospections introspections) {
        this.introspections = introspections;
    }

    @Override
    @NonNull
    public E deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super E> type) throws IOException {
        Class t2 = type.getType();
        String s2 = decoder.decodeString();
        try {
            return (E)Enum.valueOf(t2, s2);
        }
        catch (IllegalArgumentException e) {
            try {
                return (E)Enum.valueOf(t2, s2.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception ex) {
                throw e;
            }
        }
    }

    @Override
    @NonNull
    public Deserializer<E> createSpecific(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super E> type) {
        try {
            BeanIntrospection<E> deserializableIntrospection = this.introspections.getDeserializableIntrospection(type);
            Argument<?>[] constructorArguments = deserializableIntrospection.getConstructorArguments();
            if (constructorArguments.length != 1) {
                throw new SerdeException("Creator method for Enums must accept exactly 1 argument");
            }
            Argument<Object> argumentType = constructorArguments[0];
            Deserializer<Object> argumentDeserializer = context.findDeserializer(argumentType);
            return new EnumCreatorDeserializer<E>(argumentType, argumentDeserializer, deserializableIntrospection, argumentType.isNullable());
        }
        catch (IntrospectionException | SerdeException e) {
            return this;
        }
    }

    @Override
    @NonNull
    public Serializer<E> createSpecific(@NonNull Serializer.EncoderContext context, @NonNull Argument<? extends E> type) throws SerdeException {
        try {
            BeanIntrospection<E> si = this.introspections.getSerializableIntrospection(type);
            for (BeanMethod<E, Object> beanMethod : si.getBeanMethods()) {
                if (!beanMethod.getAnnotationMetadata().hasDeclaredAnnotation(SerdeConfig.SerValue.class)) continue;
                Serializer<Object> valueSerializer = context.findSerializer(beanMethod.getReturnType().asArgument());
                return (encoder, subContext, subType, value) -> {
                    Object result = beanMethod.invoke(value, new Object[0]);
                    if (result == null) {
                        encoder.encodeNull();
                    } else {
                        valueSerializer.serialize(encoder, subContext, subType, result);
                    }
                };
            }
            for (BeanProperty beanProperty : si.getBeanProperties()) {
                if (!beanProperty.getAnnotationMetadata().hasDeclaredAnnotation(SerdeConfig.SerValue.class)) continue;
                Serializer valueSerializer = context.findSerializer(beanProperty.asArgument());
                return (encoder, subContext, subType, value) -> {
                    Object result = beanProperty.get(value);
                    if (result == null) {
                        encoder.encodeNull();
                    } else {
                        valueSerializer.serialize(encoder, subContext, subType, result);
                    }
                };
            }
            return this;
        }
        catch (IntrospectionException e) {
            return this;
        }
    }

    @Override
    public void serialize(Encoder encoder, @NonNull Serializer.EncoderContext context, @NonNull Argument<? extends E> type, E value) throws IOException {
        encoder.encodeString(((Enum)value).name());
    }

    @Override
    public Argument<E> getType() {
        return Argument.ofTypeVariable(Enum.class, "E");
    }
}

