/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.OptionalLong;

@Internal
final class OptionalLongSerde
implements SerdeRegistrar<OptionalLong> {
    OptionalLongSerde() {
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends OptionalLong> type, OptionalLong value) throws IOException {
        if (value.isPresent()) {
            encoder.encodeLong(value.getAsLong());
        } else {
            encoder.encodeNull();
        }
    }

    @Override
    public OptionalLong deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super OptionalLong> type) throws IOException {
        if (decoder.decodeNull()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(decoder.decodeLong());
    }

    @Override
    public OptionalLong deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super OptionalLong> type) throws IOException {
        return this.deserialize(decoder, context, (Argument)type);
    }

    @Override
    public OptionalLong getDefaultValue(Deserializer.DecoderContext context, Argument<? super OptionalLong> type) {
        return OptionalLong.empty();
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, OptionalLong value) {
        return value == null || value.isEmpty();
    }

    @Override
    public boolean isAbsent(Serializer.EncoderContext context, OptionalLong value) {
        return value == null || value.isEmpty();
    }

    @Override
    public Argument<OptionalLong> getType() {
        return Argument.of(OptionalLong.class);
    }
}

