/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.exec;

import com.github.dockerjava.api.command.ListTasksCmd;
import com.github.dockerjava.api.model.Task;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.MediaType;
import org.testcontainers.shaded.com.github.dockerjava.core.WebTarget;
import org.testcontainers.shaded.com.github.dockerjava.core.exec.AbstrSyncDockerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.core.util.FiltersEncoder;

public class ListTasksCmdExec
extends AbstrSyncDockerCmdExec<ListTasksCmd, List<Task>>
implements ListTasksCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListTasksCmdExec.class);

    public ListTasksCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Task> execute(ListTasksCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/tasks");
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", FiltersEncoder.jsonEncode(command.getFilters()));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List<Task> tasks = webTarget.request().accept(MediaType.APPLICATION_JSON).get(new TypeReference<List<Task>>(){});
        LOGGER.trace("Response: {}", (Object)tasks);
        return tasks;
    }
}

