/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.zeroturnaround.exec.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamPumper
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(StreamPumper.class);
    private static final int DEFAULT_SIZE = 1024;
    private final InputStream is;
    private final OutputStream os;
    private final int size;
    private boolean finished;
    private final boolean closeWhenExhausted;
    private final boolean flushImmediately;

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted, boolean flushImmediately) {
        this.is = is;
        this.os = os;
        this.size = 1024;
        this.closeWhenExhausted = closeWhenExhausted;
        this.flushImmediately = flushImmediately;
    }

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted, int size, boolean flushImmediately) {
        this.is = is;
        this.os = os;
        this.size = size > 0 ? size : 1024;
        this.closeWhenExhausted = closeWhenExhausted;
        this.flushImmediately = flushImmediately;
    }

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        this.is = is;
        this.os = os;
        this.size = 1024;
        this.closeWhenExhausted = closeWhenExhausted;
        this.flushImmediately = false;
    }

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted, int size) {
        this.is = is;
        this.os = os;
        this.size = size > 0 ? size : 1024;
        this.closeWhenExhausted = closeWhenExhausted;
        this.flushImmediately = false;
    }

    public StreamPumper(InputStream is, OutputStream os) {
        this(is, os, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.trace("{}\u00a0started.", (Object)this);
        StreamPumper streamPumper = this;
        synchronized (streamPumper) {
            this.finished = false;
        }
        byte[] buf = new byte[this.size];
        try {
            int length;
            while ((length = this.is.read(buf)) > 0) {
                this.os.write(buf, 0, length);
                if (!this.flushImmediately) continue;
                this.os.flush();
            }
        }
        catch (Exception e) {
            log.trace("{}\u00a0finished.", (Object)this);
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException e2) {
                    log.error("Got exception while closing exhausted output stream", e2);
                }
            }
            StreamPumper streamPumper2 = this;
            synchronized (streamPumper2) {
                this.finished = true;
                this.notifyAll();
            }
        }
        finally {
            log.trace("{}\u00a0finished.", (Object)this);
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException e) {
                    log.error("Got exception while closing exhausted output stream", e);
                }
            }
            StreamPumper e = this;
            synchronized (e) {
                this.finished = true;
                this.notifyAll();
            }
        }
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }
}

