/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.server.netty.HttpCompressionStrategy;
import io.micronaut.http.server.netty.handler.Compressor;
import io.micronaut.http.server.netty.handler.MultiplexedServerHandler;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

@Internal
public final class Http2ServerHandler
extends MultiplexedServerHandler
implements Http2FrameListener {
    private static final Map<Http2Error, Exception> HTTP2_ERRORS = new EnumMap<Http2Error, Exception>(Http2Error.class);
    private Http2ConnectionHandler connectionHandler;
    private Http2Connection.PropertyKey streamKey;
    private boolean reading = false;

    Http2ServerHandler(RequestHandler requestHandler) {
        super(requestHandler);
    }

    private void init(Http2ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
        this.streamKey = connectionHandler.connection().newKey();
    }

    @Override
    void flush() {
        if (!this.reading) {
            this.connectionHandler.flush(this.ctx);
        }
    }

    @Override
    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        MultiplexedServerHandler.MultiplexedStream stream = (MultiplexedServerHandler.MultiplexedStream)this.connectionHandler.connection().stream(streamId).getProperty(this.streamKey);
        if (stream == null) {
            return padding;
        }
        return stream.onDataRead(data, endOfStream) + padding;
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, 0, (short)16, false, padding, endOfStream);
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream;
        io.netty.handler.codec.http2.Http2Stream str = this.connectionHandler.connection().stream(streamId);
        Http2Stream existing = str.setProperty(this.streamKey, stream = new Http2Stream(str));
        if (existing != null) {
            str.setProperty(this.streamKey, existing);
            return;
        }
        stream.onHeadersRead(HttpConversionUtil.toHttpRequest(streamId, headers, true), endOfStream);
    }

    @Override
    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    @Override
    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        MultiplexedServerHandler.MultiplexedStream stream = (MultiplexedServerHandler.MultiplexedStream)this.connectionHandler.connection().stream(streamId).getProperty(this.streamKey);
        if (stream != null) {
            Http2Error http2Error = Http2Error.valueOf(errorCode);
            if (http2Error == null) {
                http2Error = Http2Error.INTERNAL_ERROR;
            }
            stream.onRstStreamRead(HTTP2_ERRORS.get((Object)http2Error));
        }
    }

    @Override
    public void onSettingsAckRead(ChannelHandlerContext ctx) {
    }

    @Override
    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
    }

    @Override
    public void onPingRead(ChannelHandlerContext ctx, long data) {
    }

    @Override
    public void onPingAckRead(ChannelHandlerContext ctx, long data) {
    }

    @Override
    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
    }

    @Override
    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
        Http2Error http2Error = Http2Error.valueOf(errorCode);
        if (http2Error == null) {
            http2Error = Http2Error.INTERNAL_ERROR;
        }
        Exception e = HTTP2_ERRORS.get((Object)http2Error);
        this.connectionHandler.connection().forEachActiveStream(s2 -> {
            Http2Stream stream = (Http2Stream)s2.getProperty(this.streamKey);
            if (stream != null) {
                stream.onGoAwayRead(e);
            }
            return true;
        });
    }

    @Override
    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    @Override
    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
    }

    static {
        for (Http2Error value : Http2Error.values()) {
            Exception e = value == Http2Error.CANCEL ? StacklessStreamClosedChannelException.INSTANCE : new StacklessHttp2Exception(value);
            HTTP2_ERRORS.put(value, e);
        }
    }

    private final class Http2Stream
    extends MultiplexedServerHandler.MultiplexedStream {
        final io.netty.handler.codec.http2.Http2Stream stream;
        private boolean closeInput;

        Http2Stream(io.netty.handler.codec.http2.Http2Stream stream) {
            super(Http2ServerHandler.this);
            this.closeInput = false;
            this.stream = stream;
        }

        @Override
        void notifyDataConsumed(int n) {
            if (this.stream.id() == 1) {
                return;
            }
            try {
                Http2ServerHandler.this.connectionHandler.connection().local().flowController().consumeBytes(this.stream, n);
            }
            catch (Http2Exception e) {
                throw new IllegalArgumentException("n > unconsumedBytes", e);
            }
        }

        @Override
        boolean reset(Throwable cause) {
            if (cause instanceof Http2Exception) {
                Http2Exception h2e = (Http2Exception)cause;
                Http2ServerHandler.this.connectionHandler.encoder().writeRstStream(Http2ServerHandler.this.ctx, this.stream.id(), h2e.error().code(), Http2ServerHandler.this.ctx.voidPromise());
                return true;
            }
            Http2ServerHandler.this.connectionHandler.encoder().writeRstStream(Http2ServerHandler.this.ctx, this.stream.id(), Http2Error.INTERNAL_ERROR.code(), Http2ServerHandler.this.ctx.voidPromise());
            return false;
        }

        @Override
        void closeInput() {
            this.closeInput = true;
            if (this.stream.state() == Http2Stream.State.HALF_CLOSED_LOCAL) {
                Http2ServerHandler.this.connectionHandler.encoder().writeRstStream(Http2ServerHandler.this.ctx, this.stream.id(), Http2Error.CANCEL.code(), Http2ServerHandler.this.ctx.voidPromise());
                Http2ServerHandler.this.flush();
            }
        }

        @Override
        void writeHeaders(HttpResponse headers, boolean endStream, ChannelPromise promise) {
            if (endStream && this.closeInput) {
                promise = promise.unvoid();
                promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.closeInput()));
            }
            Http2ServerHandler.this.connectionHandler.encoder().writeHeaders(Http2ServerHandler.this.ctx, this.stream.id(), HttpConversionUtil.toHttp2Headers(headers, true), 0, endStream, promise);
        }

        @Override
        void writeData0(ByteBuf data, boolean endStream, ChannelPromise promise) {
            if (endStream && this.closeInput) {
                promise = promise.unvoid();
                promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.closeInput()));
            }
            Http2ServerHandler.this.connectionHandler.encoder().writeData(Http2ServerHandler.this.ctx, this.stream.id(), data, 0, endStream, promise);
        }
    }

    private static class StacklessStreamClosedChannelException
    extends ClosedChannelException {
        static final StacklessStreamClosedChannelException INSTANCE = new StacklessStreamClosedChannelException();

        private StacklessStreamClosedChannelException() {
        }

        @Override
        public String getMessage() {
            return "HTTP2 peer cancelled request stream";
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class StacklessHttp2Exception
    extends Http2Exception {
        StacklessHttp2Exception(Http2Error error) {
            super(error, "HTTP/2 peer sent error: " + error);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static final class ConnectionHandlerBuilder
    extends AbstractHttp2ConnectionHandlerBuilder<ConnectionHandler, ConnectionHandlerBuilder> {
        private final Http2ServerHandler frameListener;

        public ConnectionHandlerBuilder(RequestHandler requestHandler) {
            this.frameListener = new Http2ServerHandler(requestHandler);
        }

        @Override
        public ConnectionHandlerBuilder frameLogger(Http2FrameLogger frameLogger) {
            return (ConnectionHandlerBuilder)super.frameLogger(frameLogger);
        }

        @Override
        public ConnectionHandlerBuilder validateHeaders(boolean validateHeaders) {
            return (ConnectionHandlerBuilder)super.validateHeaders(validateHeaders);
        }

        @Override
        public ConnectionHandlerBuilder initialSettings(Http2Settings settings) {
            return (ConnectionHandlerBuilder)super.initialSettings(settings);
        }

        public ConnectionHandlerBuilder compressor(HttpCompressionStrategy compressionStrategy) {
            if (compressionStrategy.isEnabled()) {
                this.frameListener.compressor(new Compressor(compressionStrategy));
            }
            return this;
        }

        @Override
        public ConnectionHandler build() {
            this.connection(new DefaultHttp2Connection(this.isServer(), this.maxReservedStreams()));
            this.frameListener(new DelegatingDecompressorFrameListener(this.connection(), this.frameListener, false));
            return (ConnectionHandler)super.build();
        }

        @Override
        protected ConnectionHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
            ConnectionHandler ch = new ConnectionHandler(decoder, encoder, initialSettings, this.decoupleCloseAndGoAway(), this.flushPreface(), this.frameListener);
            this.frameListener.init(ch);
            return ch;
        }
    }

    static final class ConnectionHandler
    extends Http2ConnectionHandler {
        private final Http2ServerHandler handler;

        private ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean decoupleCloseAndGoAway, boolean flushPreface, Http2ServerHandler handler) {
            super(decoder, encoder, initialSettings, decoupleCloseAndGoAway, flushPreface);
            this.handler = handler;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.handler.ctx = ctx;
            super.handlerAdded(ctx);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.handler.reading = true;
            super.channelRead(ctx, msg);
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            this.connection().forEachActiveStream(s2 -> {
                Http2Stream stream = (Http2Stream)s2.getProperty(this.handler.streamKey);
                if (stream != null) {
                    stream.devolveToStreaming();
                }
                return true;
            });
            this.handler.reading = false;
            super.channelReadComplete(ctx);
        }

        @Override
        protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
            super.handlerRemoved0(ctx);
            this.connection().forEachActiveStream(s2 -> {
                Http2Stream stream = (Http2Stream)s2.getProperty(this.handler.streamKey);
                if (stream != null) {
                    stream.onGoAwayRead(StacklessStreamClosedChannelException.INSTANCE);
                }
                return true;
            });
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
                HttpServerUpgradeHandler.UpgradeEvent upgrade = (HttpServerUpgradeHandler.UpgradeEvent)evt;
                FullHttpRequest fhr = upgrade.upgradeRequest();
                io.netty.handler.codec.http2.Http2Stream cs = this.connection().stream(1);
                Http2ServerHandler http2ServerHandler = this.handler;
                Objects.requireNonNull(http2ServerHandler);
                Http2Stream stream = http2ServerHandler.new Http2Stream(cs);
                cs.setProperty(this.handler.streamKey, stream);
                boolean empty = !fhr.content().isReadable();
                stream.onHeadersRead(fhr, empty);
                if (!empty) {
                    stream.onDataRead(fhr.content(), true);
                }
            }
            super.userEventTriggered(ctx, evt);
        }
    }
}

