/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.Arrays;

@Internal
final class FloatArraySerde
implements SerdeRegistrar<float[]> {
    FloatArraySerde() {
    }

    @Override
    public float[] deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super float[]> type) throws IOException {
        Decoder arrayDecoder = decoder.decodeArray();
        float[] buffer = new float[50];
        int index = 0;
        while (arrayDecoder.hasNextArrayValue()) {
            if (buffer.length == index) {
                buffer = Arrays.copyOf(buffer, buffer.length * 2);
            }
            if (!arrayDecoder.decodeNull()) {
                buffer[index] = arrayDecoder.decodeFloat();
            }
            ++index;
        }
        arrayDecoder.finishStructure();
        return Arrays.copyOf(buffer, index);
    }

    @Override
    public float[] deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super float[]> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends float[]> type, float[] value) throws IOException {
        Encoder arrayEncoder = encoder.encodeArray(type);
        for (float i : value) {
            arrayEncoder.encodeFloat(i);
        }
        arrayEncoder.finishStructure();
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, float[] value) {
        return value == null || value.length == 0;
    }

    @Override
    public Argument<float[]> getType() {
        return Argument.of(float[].class);
    }
}

