/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.reference.SerializationReference;
import io.micronaut.serde.support.serializers.SerBean;
import java.io.IOException;

@Internal
final class CustomizedObjectSerializer<T>
implements ObjectSerializer<T> {
    private final SerBean<T> serBean;

    CustomizedObjectSerializer(SerBean<T> serBean) {
        this.serBean = serBean;
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        try {
            Encoder childEncoder = encoder.encodeObject(type);
            this.serializeIntoInternal(childEncoder, value, context);
            childEncoder.finishStructure();
        }
        catch (StackOverflowError e) {
            throw new SerdeException("Infinite recursion serializing type: " + type.getType().getSimpleName() + " at path " + encoder.currentPath(), e);
        }
        catch (IntrospectionException e) {
            throw new SerdeException("Error serializing value at path: " + encoder.currentPath() + ". No serializer found for type: " + type, e);
        }
    }

    @Override
    public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        try {
            this.serializeIntoInternal(encoder, value, context);
        }
        catch (StackOverflowError e) {
            throw new SerdeException("Infinite recursion serializing type: " + type.getType().getSimpleName() + " at path " + encoder.currentPath(), e);
        }
        catch (IntrospectionException e) {
            throw new SerdeException("Error serializing value at path: " + encoder.currentPath() + ". No serializer found for type: " + type, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeIntoInternal(Encoder objectEncoder, T objectValue, Serializer.EncoderContext context) throws IOException {
        block9: for (SerBean.SerProperty property : this.serBean.writeProperties) {
            SerializationReference ref;
            Object propertyValue = property.get(objectValue);
            String backRef = property.backRef;
            if (backRef != null && (ref = context.resolveReference(new SerializationReference(backRef, this.serBean.introspection, property.argument, propertyValue, property.serializer))) == null) continue;
            Serializer<Object> serializer = property.serializer;
            if (this.serBean.propertyFilter != null) {
                if (!this.serBean.propertyFilter.shouldInclude(context, serializer, objectValue, property.name, propertyValue)) {
                    continue;
                }
            } else {
                switch (property.include) {
                    case NON_NULL: {
                        if (propertyValue != null) break;
                        continue block9;
                    }
                    case NON_ABSENT: {
                        if (!serializer.isAbsent(context, propertyValue)) break;
                        continue block9;
                    }
                    case NON_EMPTY: {
                        if (!serializer.isEmpty(context, propertyValue)) break;
                        continue block9;
                    }
                    case NEVER: {
                        continue block9;
                    }
                }
            }
            if (property.views != null && !context.hasView(property.views)) continue;
            String managedRef = property.managedRef;
            if (managedRef != null) {
                context.pushManagedRef(new SerializationReference(managedRef, this.serBean.introspection, property.argument, objectValue, property.serializer));
            }
            try {
                if (property.serializableInto) {
                    if (property.objectSerializer != null) {
                        property.objectSerializer.serializeInto(objectEncoder, context, property.argument, propertyValue);
                        continue;
                    }
                    throw new SerdeException("Serializer for a property: " + property.name + " doesn't support serializing into an existing object");
                }
                objectEncoder.encodeKey(property.name);
                if (propertyValue == null) {
                    objectEncoder.encodeNull();
                    continue;
                }
                serializer.serialize(objectEncoder, context, property.argument, propertyValue);
            }
            finally {
                if (managedRef == null) continue;
                context.popManagedRef();
            }
        }
    }
}

