/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.testcontainers;

import io.micronaut.testresources.core.ToggableTestResourcesResolver;
import io.micronaut.testresources.testcontainers.DockerSupport;
import io.micronaut.testresources.testcontainers.TestContainerMetadata;
import io.micronaut.testresources.testcontainers.TestContainerMetadataSupport;
import io.micronaut.testresources.testcontainers.TestContainers;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class GenericTestContainerProvider
implements ToggableTestResourcesResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericTestContainerProvider.class);

    @Override
    public String getDisplayName() {
        return "Generic Test Containers";
    }

    @Override
    public String getName() {
        return "generic";
    }

    @Override
    public int getOrder() {
        return 1000;
    }

    @Override
    public boolean isEnabled(Map<String, Object> testResourcesConfig) {
        if (!DockerSupport.isDockerAvailable()) {
            return false;
        }
        return ToggableTestResourcesResolver.super.isEnabled(testResourcesConfig);
    }

    @Override
    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        List<String> resolvable = this.containerMetadataFrom(testResourcesConfig).flatMap(e -> Stream.concat(e.getExposedPorts().keySet().stream(), e.getHostNames().stream())).distinct().collect(Collectors.toList());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Properties which can be resolved by generic containers: {}", (Object)resolvable);
        }
        return resolvable;
    }

    @NotNull
    private Stream<TestContainerMetadata> containerMetadataFrom(Map<String, Object> testResourcesConfig) {
        List<String> genericContainers = GenericTestContainerProvider.containerNamesFrom(testResourcesConfig);
        return TestContainerMetadataSupport.containerMetadataFor(genericContainers, testResourcesConfig);
    }

    @Override
    public Optional<String> resolve(String propertyName, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
        class MappedContainer {
            private final TestContainerMetadata md;
            private final GenericContainer<?> container;

            MappedContainer(TestContainerMetadata md, GenericContainer<?> container) {
                this.md = md;
                this.container = container;
            }
        }
        return this.containerMetadataFrom(testResourcesConfig).filter(e -> e.getExposedPorts().containsKey(propertyName) || e.getHostNames().contains(propertyName)).filter(md -> md.getImageName().isPresent()).findFirst().map(md -> {
            DockerImageName imageName = DockerImageName.parse(md.getImageName().get());
            return new MappedContainer((TestContainerMetadata)md, TestContainers.getOrCreate(propertyName, GenericTestContainerProvider.class, md.getId(), properties, () -> imageName, unused -> {
                if (!md.getDependencies().isEmpty()) {
                    this.resolveDependencies(md.getDependencies(), this.containerMetadataFrom(testResourcesConfig).toList(), properties, testResourcesConfig);
                }
                GenericContainer selfGenericContainer = new GenericContainer(imageName);
                return TestContainerMetadataSupport.applyMetadata(md, selfGenericContainer);
            }));
        }).map(e -> {
            Integer mappedPort = e.md.getExposedPorts().get(propertyName);
            if (mappedPort != null) {
                return String.valueOf(e.container.getMappedPort(mappedPort));
            }
            if (e.md.getHostNames().contains(propertyName)) {
                return e.container.getHost();
            }
            return null;
        });
    }

    private void resolveDependencies(Set<String> dependencies, List<TestContainerMetadata> containersMetadata, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
        for (String dependency : dependencies) {
            this.resolveDependency(dependency, containersMetadata, properties, testResourcesConfig);
        }
    }

    private void resolveDependency(String dependency, List<TestContainerMetadata> containersMetadata, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
        String propertyToResolve = (String)containersMetadata.stream().filter(md -> md.getId().equals(dependency)).findFirst().flatMap(md -> Stream.concat(md.getHostNames().stream(), md.getExposedPorts().keySet().stream()).findFirst()).orElseThrow(() -> new IllegalArgumentException("Dependent container '" + dependency + "' doesn't exist or cannot be resolved"));
        this.resolve(propertyToResolve, properties, testResourcesConfig);
    }

    private static List<String> containerNamesFrom(Map<String, Object> configuration) {
        return configuration.keySet().stream().filter(key -> key.startsWith("containers.")).map(key -> key.substring("containers.".length())).map(key -> key.substring(0, key.indexOf(46))).distinct().collect(Collectors.toList());
    }
}

