/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.model.Container;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import lombok.NonNull;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ComposeDelegate;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.FailureDetectingExternalResource;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.org.apache.commons.lang3.SystemUtils;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;

public class DockerComposeContainer<SELF extends DockerComposeContainer<SELF>>
extends FailureDetectingExternalResource
implements Startable {
    private static final Logger log = LoggerFactory.getLogger(DockerComposeContainer.class);
    private final Map<String, Integer> scalingPreferences = new HashMap<String, Integer>();
    private boolean localCompose;
    private boolean pull = true;
    private boolean build = false;
    private Set<String> options = new HashSet<String>();
    private boolean tailChildContainers;
    private static final Object MUTEX = new Object();
    private List<String> services = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private RemoveImages removeImages;
    private boolean removeVolumes = true;
    public static final String COMPOSE_EXECUTABLE = SystemUtils.IS_OS_WINDOWS ? "docker-compose.exe" : "docker-compose";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse("docker/compose:1.29.2");
    private final ComposeDelegate composeDelegate;
    private String project;

    @Deprecated
    public DockerComposeContainer(File composeFile, String identifier) {
        this(identifier, composeFile);
    }

    public DockerComposeContainer(File ... composeFiles) {
        this(Arrays.asList(composeFiles));
    }

    public DockerComposeContainer(List<File> composeFiles) {
        this(Base58.randomString(6).toLowerCase(), composeFiles);
    }

    public DockerComposeContainer(String identifier, File ... composeFiles) {
        this(identifier, Arrays.asList(composeFiles));
    }

    public DockerComposeContainer(String identifier, List<File> composeFiles) {
        this.composeDelegate = new ComposeDelegate(ComposeDelegate.ComposeVersion.V1, composeFiles, identifier, COMPOSE_EXECUTABLE, DEFAULT_IMAGE_NAME);
        this.project = this.composeDelegate.getProject();
    }

    @Override
    @Deprecated
    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    @Override
    @Deprecated
    public void starting(Description description) {
        this.start();
    }

    @Override
    @Deprecated
    protected void succeeded(Description description) {
    }

    @Override
    @Deprecated
    protected void failed(Throwable e, Description description) {
    }

    @Override
    @Deprecated
    public void finished(Description description) {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = MUTEX;
        synchronized (object) {
            this.composeDelegate.registerContainersForShutdown();
            if (this.pull) {
                try {
                    this.composeDelegate.pullImages();
                }
                catch (ContainerLaunchException e) {
                    log.warn("Exception while pulling images, using local images if available", e);
                }
            }
            this.composeDelegate.createServices(this.localCompose, this.build, this.options, this.services, this.scalingPreferences, this.env);
            this.composeDelegate.startAmbassadorContainer();
            this.composeDelegate.waitUntilServiceStarted(this.tailChildContainers);
        }
    }

    @VisibleForTesting
    List<Container> listChildContainers() {
        return this.composeDelegate.listChildContainers();
    }

    public SELF withServices(String ... services) {
        if (services == null) {
            throw new NullPointerException("services is marked non-null but is null");
        }
        this.services = Arrays.asList(services);
        return this.self();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = MUTEX;
        synchronized (object) {
            try {
                this.composeDelegate.getAmbassadorContainer().stop();
                String cmd = "down";
                if (this.removeVolumes) {
                    cmd = cmd + " -v";
                }
                if (this.removeImages != null) {
                    cmd = cmd + " --rmi " + this.removeImages.dockerRemoveImagesType();
                }
                this.composeDelegate.runWithCompose(this.localCompose, cmd);
            }
            finally {
                this.project = this.composeDelegate.randomProjectId();
            }
        }
    }

    public SELF withExposedService(String serviceName, int servicePort) {
        this.composeDelegate.withExposedService(serviceName, servicePort, Wait.defaultWaitStrategy());
        return this.self();
    }

    public DockerComposeContainer withExposedService(String serviceName, int instance, int servicePort) {
        return this.withExposedService(serviceName + "_" + instance, servicePort);
    }

    public DockerComposeContainer withExposedService(String serviceName, int instance, int servicePort, WaitStrategy waitStrategy) {
        this.composeDelegate.withExposedService(serviceName + "_" + instance, servicePort, waitStrategy);
        return this.self();
    }

    public SELF withExposedService(String serviceName, int servicePort, @NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked non-null but is null");
        }
        this.composeDelegate.withExposedService(serviceName, servicePort, waitStrategy);
        return this.self();
    }

    public SELF waitingFor(String serviceName, @NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked non-null but is null");
        }
        String serviceInstanceName = this.composeDelegate.getServiceInstanceName(serviceName);
        this.composeDelegate.addWaitStrategy(serviceInstanceName, waitStrategy);
        return this.self();
    }

    public String getServiceHost(String serviceName, Integer servicePort) {
        return this.composeDelegate.getServiceHost();
    }

    public Integer getServicePort(String serviceName, Integer servicePort) {
        return this.composeDelegate.getServicePort(serviceName, servicePort);
    }

    public SELF withScaledService(String serviceBaseName, int numInstances) {
        this.scalingPreferences.put(serviceBaseName, numInstances);
        return this.self();
    }

    public SELF withEnv(String key, String value) {
        this.env.put(key, value);
        return this.self();
    }

    public SELF withEnv(Map<String, String> env) {
        env.forEach(this.env::put);
        return this.self();
    }

    public SELF withLocalCompose(boolean localCompose) {
        this.localCompose = localCompose;
        return this.self();
    }

    public SELF withPull(boolean pull) {
        this.pull = pull;
        return this.self();
    }

    public SELF withTailChildContainers(boolean tailChildContainers) {
        this.tailChildContainers = tailChildContainers;
        return this.self();
    }

    public SELF withLogConsumer(String serviceName, Consumer<OutputFrame> consumer) {
        this.composeDelegate.withLogConsumer(serviceName, consumer);
        return this.self();
    }

    public SELF withBuild(boolean build) {
        this.build = build;
        return this.self();
    }

    public SELF withOptions(String ... options) {
        this.options = new HashSet<String>(Arrays.asList(options));
        return this.self();
    }

    public SELF withRemoveImages(RemoveImages removeImages) {
        this.removeImages = removeImages;
        return this.self();
    }

    public SELF withRemoveVolumes(boolean removeVolumes) {
        this.removeVolumes = removeVolumes;
        return this.self();
    }

    public SELF withStartupTimeout(Duration startupTimeout) {
        this.composeDelegate.setStartupTimeout(startupTimeout);
        return this.self();
    }

    public Optional<ContainerState> getContainerByServiceName(String serviceName) {
        return this.composeDelegate.getContainerByServiceName(serviceName);
    }

    private void followLogs(String containerId, Consumer<OutputFrame> consumer) {
        this.followLogs(containerId, consumer);
    }

    private SELF self() {
        return (SELF)this;
    }

    public static enum RemoveImages {
        ALL("all"),
        LOCAL("local");

        private final String dockerRemoveImagesType;

        private RemoveImages(String dockerRemoveImagesType) {
            this.dockerRemoveImagesType = dockerRemoveImagesType;
        }

        public String dockerRemoveImagesType() {
            return this.dockerRemoveImagesType;
        }
    }
}

