/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.mime.smime;

import java.io.IOException;
import java.io.InputStream;
import org.testcontainers.shaded.org.bouncycastle.mime.BasicMimeParser;
import org.testcontainers.shaded.org.bouncycastle.mime.Headers;
import org.testcontainers.shaded.org.bouncycastle.mime.MimeParser;
import org.testcontainers.shaded.org.bouncycastle.mime.MimeParserProvider;
import org.testcontainers.shaded.org.bouncycastle.mime.smime.SMimeParserContext;
import org.testcontainers.shaded.org.bouncycastle.mime.smime.SMimeUtils;
import org.testcontainers.shaded.org.bouncycastle.operator.DigestCalculatorProvider;

public class SMimeParserProvider
implements MimeParserProvider {
    private final String defaultContentTransferEncoding;
    private final DigestCalculatorProvider digestCalculatorProvider;

    public SMimeParserProvider(String string, DigestCalculatorProvider digestCalculatorProvider) {
        this.defaultContentTransferEncoding = string;
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    @Override
    public MimeParser createParser(InputStream inputStream) throws IOException {
        return new BasicMimeParser(new SMimeParserContext(this.defaultContentTransferEncoding, this.digestCalculatorProvider), SMimeUtils.autoBuffer(inputStream));
    }

    @Override
    public MimeParser createParser(Headers headers, InputStream inputStream) throws IOException {
        return new BasicMimeParser(new SMimeParserContext(this.defaultContentTransferEncoding, this.digestCalculatorProvider), headers, SMimeUtils.autoBuffer(inputStream));
    }
}

