/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.stream;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.netty.stream.DelegateHttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;

@Internal
public class EmptyHttpRequest
extends DelegateHttpRequest
implements FullHttpRequest {
    public EmptyHttpRequest(HttpRequest request) {
        super(request);
    }

    @Override
    public FullHttpRequest setUri(String uri) {
        super.setUri(uri);
        return this;
    }

    @Override
    public FullHttpRequest setMethod(HttpMethod method) {
        super.setMethod(method);
        return this;
    }

    @Override
    public FullHttpRequest setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    @Override
    public FullHttpRequest copy() {
        HttpRequest httpRequest = this.request;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest httpRequest2 = (FullHttpRequest)httpRequest;
            return new EmptyHttpRequest(httpRequest2.copy());
        }
        DefaultHttpRequest copy = new DefaultHttpRequest(this.protocolVersion(), this.method(), this.uri());
        copy.headers().set(this.headers());
        return new EmptyHttpRequest(copy);
    }

    @Override
    public FullHttpRequest retain(int increment) {
        ReferenceCountUtil.retain(this.message, increment);
        return this;
    }

    @Override
    public FullHttpRequest retain() {
        ReferenceCountUtil.retain(this.message);
        return this;
    }

    @Override
    public FullHttpRequest touch() {
        HttpRequest httpRequest = this.request;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest httpRequest2 = (FullHttpRequest)httpRequest;
            return httpRequest2.touch();
        }
        return this;
    }

    @Override
    public FullHttpRequest touch(Object o) {
        HttpRequest httpRequest = this.request;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest httpRequest2 = (FullHttpRequest)httpRequest;
            return httpRequest2.touch(o);
        }
        return this;
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return new DefaultHttpHeaders();
    }

    @Override
    public FullHttpRequest duplicate() {
        HttpRequest httpRequest = this.request;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest httpRequest2 = (FullHttpRequest)httpRequest;
            return httpRequest2.duplicate();
        }
        return this;
    }

    @Override
    public FullHttpRequest retainedDuplicate() {
        HttpRequest httpRequest = this.request;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest httpRequest2 = (FullHttpRequest)httpRequest;
            return httpRequest2.retainedDuplicate();
        }
        return this;
    }

    @Override
    public FullHttpRequest replace(ByteBuf byteBuf) {
        if (this.message instanceof FullHttpRequest) {
            return ((FullHttpRequest)this.request).replace(byteBuf);
        }
        return this;
    }

    @Override
    public ByteBuf content() {
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    public int refCnt() {
        HttpMessage httpMessage = this.message;
        if (httpMessage instanceof ReferenceCounted) {
            ReferenceCounted counted = (ReferenceCounted)((Object)httpMessage);
            return counted.refCnt();
        }
        return 1;
    }

    @Override
    public boolean release() {
        return ReferenceCountUtil.release(this.message);
    }

    @Override
    public boolean release(int decrement) {
        return ReferenceCountUtil.release(this.message, decrement);
    }
}

