/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueResolver;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Supplier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MappingAnnotationMetadataDelegate
implements AnnotationMetadataDelegate {
    public abstract <T extends Annotation> AnnotationValue<T> mapAnnotationValue(AnnotationValue<T> var1);

    @Override
    public Optional<String> stringValue(String annotation, String member) {
        return this.findAnnotation(annotation).flatMap(av -> av.stringValue(member));
    }

    @Override
    public Optional<String> stringValue(Class<? extends Annotation> annotation, String member) {
        return this.stringValue(annotation.getName(), member);
    }

    @Override
    public Optional<String> stringValue(Class<? extends Annotation> annotation) {
        return this.stringValue(annotation, "value");
    }

    @Override
    public Optional<String> stringValue(String annotation) {
        return this.stringValue(annotation, "value");
    }

    @Override
    public String[] stringValues(String annotation, String member) {
        return this.findAnnotation(annotation).map(av -> av.stringValues(member)).orElse(StringUtils.EMPTY_STRING_ARRAY);
    }

    @Override
    public String[] stringValues(Class<? extends Annotation> annotation, String member) {
        return this.stringValues(annotation.getName(), member);
    }

    @Override
    public String[] stringValues(Class<? extends Annotation> annotation) {
        return this.stringValues(annotation, "value");
    }

    @Override
    public String[] stringValues(String annotation) {
        return this.stringValues(annotation, "value");
    }

    @Override
    public <E extends Enum<E>> Optional<E> enumValue(String annotation, Class<E> enumType) {
        return this.enumValue(annotation, "value", enumType);
    }

    @Override
    public <E extends Enum<E>> Optional<E> enumValue(String annotation, String member, Class<E> enumType) {
        return this.findAnnotation(annotation).flatMap(av -> av.enumValue(member, enumType));
    }

    @Override
    public <E extends Enum<E>> Optional<E> enumValue(Class<? extends Annotation> annotation, Class<E> enumType) {
        return this.enumValue(annotation.getName(), "value", enumType);
    }

    @Override
    public <E extends Enum<E>> Optional<E> enumValue(Class<? extends Annotation> annotation, String member, Class<E> enumType) {
        return this.enumValue(annotation.getName(), member, enumType);
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(String annotation, String member, Class<E> enumType) {
        return this.findAnnotation(annotation).map(av -> av.enumValues(member, enumType)).orElse((Enum[])Array.newInstance(enumType, 0));
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(String annotation, Class<E> enumType) {
        return this.enumValues(annotation, "value", enumType);
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(Class<? extends Annotation> annotation, Class<E> enumType) {
        return this.enumValues(annotation.getName(), "value", enumType);
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(Class<? extends Annotation> annotation, String member, Class<E> enumType) {
        return this.enumValues(annotation.getName(), member, enumType);
    }

    @Override
    public <T> Class<T>[] classValues(String annotation, String member) {
        return this.findAnnotation(annotation).map(av -> av.classValues(member)).orElse(ReflectionUtils.EMPTY_CLASS_ARRAY);
    }

    @Override
    public <T> Class<T>[] classValues(String annotation) {
        return this.classValues(annotation, "value");
    }

    @Override
    public <T> Class<T>[] classValues(Class<? extends Annotation> annotation) {
        return this.classValues(annotation.getName(), "value");
    }

    @Override
    public <T> Class<T>[] classValues(Class<? extends Annotation> annotation, String member) {
        return this.classValues(annotation.getName(), member);
    }

    @Override
    public Optional<Boolean> booleanValue(String annotation, String member) {
        return this.findAnnotation(annotation).flatMap(av -> av.booleanValue(member));
    }

    @Override
    public Optional<Boolean> booleanValue(Class<? extends Annotation> annotation, String member) {
        return this.booleanValue(annotation.getName(), member);
    }

    @Override
    public Optional<Boolean> booleanValue(Class<? extends Annotation> annotation) {
        return this.booleanValue(annotation.getName(), "value");
    }

    @Override
    public Optional<Boolean> booleanValue(String annotation) {
        return this.booleanValue(annotation, "value");
    }

    @Override
    public boolean isTrue(String annotation, String member) {
        return this.getValue(annotation, member, Boolean.class).orElse(false);
    }

    @Override
    public boolean isTrue(Class<? extends Annotation> annotation, String member) {
        return this.isTrue(annotation.getName(), member);
    }

    @Override
    public boolean isFalse(String annotation, String member) {
        return !this.isTrue(annotation, member);
    }

    @Override
    public boolean isFalse(Class<? extends Annotation> annotation, String member) {
        return this.isFalse(annotation.getName(), member);
    }

    @Override
    public Optional<Class> classValue(String annotation, String member) {
        return this.findAnnotation(annotation).flatMap(av -> av.classValue(member));
    }

    @Override
    public Optional<Class> classValue(String annotation) {
        return this.classValue(annotation, "value");
    }

    @Override
    public Optional<Class> classValue(Class<? extends Annotation> annotation) {
        return this.classValue(annotation.getName(), "value");
    }

    @Override
    public Optional<Class> classValue(Class<? extends Annotation> annotation, String member) {
        return this.classValue(annotation.getName(), member);
    }

    @Override
    public OptionalInt intValue(String annotation, String member) {
        return this.findAnnotation(annotation).map(AnnotationValue::intValue).orElse(OptionalInt.empty());
    }

    @Override
    public OptionalInt intValue(Class<? extends Annotation> annotation, String member) {
        return this.intValue(annotation.getName(), member);
    }

    @Override
    public OptionalInt intValue(Class<? extends Annotation> annotation) {
        return this.intValue(annotation.getName(), "value");
    }

    @Override
    public OptionalLong longValue(String annotation, String member) {
        return this.findAnnotation(annotation).map(AnnotationValueResolver::longValue).orElse(OptionalLong.empty());
    }

    @Override
    public OptionalLong longValue(Class<? extends Annotation> annotation, String member) {
        return this.longValue(annotation.getName(), member);
    }

    @Override
    public OptionalDouble doubleValue(String annotation, String member) {
        return this.findAnnotation(annotation).map(av -> av.doubleValue(member)).orElse(OptionalDouble.empty());
    }

    @Override
    public OptionalDouble doubleValue(Class<? extends Annotation> annotation, String member) {
        return this.findAnnotation(annotation).map(av -> av.doubleValue(member)).orElse(OptionalDouble.empty());
    }

    @Override
    public OptionalDouble doubleValue(Class<? extends Annotation> annotation) {
        return this.doubleValue(annotation, "value");
    }

    @Override
    public <T> Optional<T> getValue(String annotation, String member, Argument<T> requiredType) {
        return this.findAnnotation(annotation).flatMap(av -> av.get(member, requiredType));
    }

    @Override
    public <T> Optional<T> getValue(Class<? extends Annotation> annotation, String member, Argument<T> requiredType) {
        return this.findAnnotation(annotation).flatMap(av -> av.get(member, requiredType));
    }

    @Override
    public <T> Optional<T> getValue(String annotation, Argument<T> requiredType) {
        return this.getValue(annotation, "value", requiredType);
    }

    @Override
    public <T> Optional<T> getValue(Class<? extends Annotation> annotation, Argument<T> requiredType) {
        return this.getValue(annotation, "value", requiredType);
    }

    @Override
    public <T> Optional<T> getValue(Class<? extends Annotation> annotation, String member, Class<T> requiredType) {
        return this.getValue(annotation, member, Argument.of(requiredType));
    }

    @Override
    public <T> Optional<T> getValue(Class<? extends Annotation> annotation, Class<T> requiredType) {
        return this.getValue(annotation, "value", requiredType);
    }

    @Override
    public <T> Optional<T> getValue(String annotation, String member, Class<T> requiredType) {
        return this.getValue(annotation, member, Argument.of(requiredType));
    }

    @Override
    public <T> Optional<T> getValue(String annotation, Class<T> requiredType) {
        return this.getValue(annotation, "value", Argument.of(requiredType));
    }

    @Override
    public Optional<Object> getValue(String annotation, String member) {
        return this.getValue(annotation, member, Object.class);
    }

    @Override
    public Optional<Object> getValue(Class<? extends Annotation> annotation, String member) {
        return this.getValue(annotation, member, Object.class);
    }

    @Override
    public Optional<Object> getValue(String annotation) {
        return this.getValue(annotation, "value", Object.class);
    }

    @Override
    public Optional<Object> getValue(Class<? extends Annotation> annotation) {
        return this.getValue(annotation, "value", Object.class);
    }

    @Override
    public <T> OptionalValues<T> getValues(Class<? extends Annotation> annotation, Class<T> valueType) {
        return this.getValues(annotation.getName(), valueType);
    }

    @Override
    public <T> OptionalValues<T> getValues(String annotation, Class<T> valueType) {
        return OptionalValues.of(valueType, this.getValues(annotation));
    }

    @Override
    public Map<CharSequence, Object> getValues(String annotation) {
        return this.findAnnotation(annotation).map(AnnotationValue::getValues).orElse(Collections.emptyMap());
    }

    @Override
    public <T extends Annotation> AnnotationValue<T> getDeclaredAnnotation(Class<T> annotationClass) {
        AnnotationValue<T> av = this.getAnnotationMetadata().getDeclaredAnnotation(annotationClass);
        if (av != null) {
            return this.mapAnnotationValue(av);
        }
        return null;
    }

    @Override
    public <T extends Annotation> AnnotationValue<T> getAnnotation(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass.getName());
    }

    @Override
    public <T extends Annotation> AnnotationValue<T> getAnnotation(String annotation) {
        AnnotationValue av = this.getAnnotationMetadata().getAnnotation(annotation);
        if (av != null) {
            return this.mapAnnotationValue(av);
        }
        return null;
    }

    @Override
    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(String annotation) {
        AnnotationValue av = this.getAnnotationMetadata().getAnnotation(annotation);
        if (av != null) {
            return Optional.of(this.mapAnnotationValue(av));
        }
        return Optional.empty();
    }

    @Override
    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(Class<T> annotationClass) {
        return this.getAnnotationMetadata().findAnnotation(annotationClass).map(this::mapAnnotationValue);
    }

    @Override
    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(Class<T> annotationClass) {
        return this.findDeclaredAnnotation(annotationClass.getName());
    }

    @Override
    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(String annotation) {
        Optional<AnnotationValue<AnnotationValue>> av = this.getAnnotationMetadata().findDeclaredAnnotation(annotation);
        return av.map(this::mapAnnotationValue);
    }

    @Override
    public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])this.getDeclaredAnnotationValuesByType(annotationClass).stream().map(annotation -> AnnotationMetadataSupport.buildAnnotation(annotationClass, annotation)).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
    }

    @Override
    public <T extends Annotation> T[] synthesizeAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])this.getAnnotationValuesByType(annotationClass).stream().map(annotation -> AnnotationMetadataSupport.buildAnnotation(annotationClass, annotation)).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
    }

    @Override
    public <T extends Annotation> T synthesizeDeclared(Class<T> annotationClass) {
        return (T)((Annotation)this.findDeclaredAnnotation(annotationClass).map(av -> AnnotationMetadataSupport.buildAnnotation(annotationClass, av)).orElse(null));
    }

    @Override
    public <T extends Annotation> T synthesize(Class<T> annotationClass) {
        return (T)((Annotation)this.findAnnotation(annotationClass).map(av -> AnnotationMetadataSupport.buildAnnotation(annotationClass, av)).orElse(null));
    }

    @Override
    public <T extends Annotation> T synthesize(Class<T> annotationClass, String sourceAnnotation) {
        AnnotationValue<T> av = this.getAnnotation(sourceAnnotation);
        if (av != null) {
            return AnnotationMetadataSupport.buildAnnotation(annotationClass, av);
        }
        return null;
    }

    @Override
    public <T extends Annotation> T synthesizeDeclared(Class<T> annotationClass, String sourceAnnotation) {
        AnnotationValue av = this.getDeclaredAnnotation(sourceAnnotation);
        if (av != null) {
            return AnnotationMetadataSupport.buildAnnotation(annotationClass, av);
        }
        return null;
    }

    @Override
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(Class<T> annotationType) {
        return this.getAnnotationValues(() -> this.getAnnotationMetadata().getAnnotationValuesByType(annotationType));
    }

    @Override
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(Class<T> annotationType) {
        return this.getAnnotationValues(() -> this.getAnnotationMetadata().getDeclaredAnnotationValuesByType(annotationType));
    }

    @Override
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByStereotype(String stereotype) {
        return this.getAnnotationValues(() -> this.getAnnotationMetadata().getAnnotationValuesByStereotype(stereotype));
    }

    @Override
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByName(String annotationType) {
        return this.getAnnotationValues(() -> this.getAnnotationMetadata().getDeclaredAnnotationValuesByName(annotationType));
    }

    @Override
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByName(String annotationType) {
        return this.getAnnotationValues(() -> this.getAnnotationMetadata().getAnnotationValuesByName(annotationType));
    }

    private <T extends Annotation> List<AnnotationValue<T>> getAnnotationValues(Supplier<List<AnnotationValue<T>>> supplier) {
        return supplier.get().stream().map(this::mapAnnotationValue).toList();
    }
}

