/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.NumberSerde;
import java.io.IOException;
import java.util.Arrays;

@Internal
final class ByteSerde
implements SerdeRegistrar<Byte>,
NumberSerde<Byte> {
    ByteSerde() {
    }

    @Override
    public Byte deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Byte> type) throws IOException {
        return decoder.decodeByte();
    }

    @Override
    public Byte deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Byte> type) throws IOException {
        return decoder.decodeByteNullable();
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Byte> type, Byte value) throws IOException {
        encoder.encodeByte(value);
    }

    @Override
    public Argument<Byte> getType() {
        return Argument.of(Byte.class);
    }

    @Override
    public Iterable<Argument<?>> getTypes() {
        return Arrays.asList(this.getType(), Argument.BYTE);
    }

    @Override
    @Nullable
    public Byte getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Byte> type) {
        return type.isPrimitive() ? Byte.valueOf((byte)0) : null;
    }
}

