/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.NumberSerde;
import java.io.IOException;
import java.util.Arrays;

final class LongSerde
implements SerdeRegistrar<Long>,
NumberSerde<Long> {
    LongSerde() {
    }

    @Override
    public Long deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Long> type) throws IOException {
        return decoder.decodeLong();
    }

    @Override
    public Long deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Long> type) throws IOException {
        return decoder.decodeLongNullable();
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Long> type, Long value) throws IOException {
        encoder.encodeLong(value);
    }

    @Override
    public Argument<Long> getType() {
        return Argument.of(Long.class);
    }

    @Override
    public Iterable<Argument<?>> getTypes() {
        return Arrays.asList(this.getType(), Argument.LONG);
    }

    @Override
    @Nullable
    public Long getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Long> type) {
        return type.isPrimitive() ? Long.valueOf(0L) : null;
    }
}

