/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerializerRegistrar;
import io.micronaut.serde.util.CustomizableSerializer;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

@Internal
final class OptionalValuesSerializer<V>
implements CustomizableSerializer<OptionalValues<V>>,
SerializerRegistrar<OptionalValues<V>> {
    OptionalValuesSerializer() {
    }

    @Override
    public ObjectSerializer<OptionalValues<V>> createSpecific(Serializer.EncoderContext context, Argument<? extends OptionalValues<V>> type) throws SerdeException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty(generics)) {
            throw new SerdeException("Cannot serialize raw OptionalValues");
        }
        Object generic2 = generics[0];
        final Serializer valueSerializer = context.findSerializer(generic2).createSpecific(context, generic2);
        return new ObjectSerializer<OptionalValues<V>>((Argument)generic2){
            final /* synthetic */ Argument val$generic;
            {
                this.val$generic = argument;
            }

            @Override
            public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends OptionalValues<V>> type, OptionalValues<V> value) throws IOException {
                for (CharSequence key : value) {
                    Optional opt = value.get(key);
                    if (!opt.isPresent()) continue;
                    encoder.encodeKey(key.toString());
                    valueSerializer.serialize(encoder, context, this.val$generic, opt.get());
                }
            }

            @Override
            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends OptionalValues<V>> type, OptionalValues<V> value) throws IOException {
                Objects.requireNonNull(value, "Value cannot be null");
                Encoder objectEncoder = encoder.encodeObject(type);
                this.serializeInto(encoder, context, type, value);
                objectEncoder.finishStructure();
            }
        };
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, OptionalValues<V> value) {
        return value.isEmpty();
    }

    @Override
    public Argument<OptionalValues<V>> getType() {
        return Argument.of(OptionalValues.class, Argument.ofTypeVariable(Object.class, "V"));
    }
}

