/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.util;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;

@Internal
public final class MatchArgumentQualifier<T>
implements Qualifier<T> {
    private static final Logger LOG = ClassUtils.getLogger(MatchArgumentQualifier.class);
    private final Argument<?> argument;
    private final Argument<?> superArgument;

    private MatchArgumentQualifier(Argument<?> argument, Argument<?> superArgument) {
        this.argument = argument;
        this.superArgument = superArgument;
    }

    public static <T> MatchArgumentQualifier<T> ofArgument(Argument<?> argument) {
        return new MatchArgumentQualifier<T>(argument, null);
    }

    public static <T> MatchArgumentQualifier<T> ofSuperVariable(Class<T> beanType, Argument<?> argument) {
        Argument superArgument = Argument.ofTypeVariable(argument.getType(), null, argument.getAnnotationMetadata(), argument.getTypeParameters());
        return new MatchArgumentQualifier<T>(Argument.of(beanType, superArgument), superArgument);
    }

    public static <T> MatchArgumentQualifier<T> ofExtendsVariable(Class<T> beanType, Argument<?> argument) {
        return new MatchArgumentQualifier<T>(Argument.of(beanType, Argument.ofTypeVariable(argument.getType(), null, argument.getAnnotationMetadata(), argument.getTypeParameters())), null);
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return this.filter(beanType, candidates.toList()).stream();
    }

    @Override
    public boolean doesQualify(Class<T> beanType, Collection<? extends BeanType<T>> candidates) {
        return !this.filter(beanType, candidates).isEmpty();
    }

    @Override
    public boolean doesQualify(Class<T> beanType, BeanType<T> candidate) {
        throw new IllegalStateException("Not supported!");
    }

    @Override
    public <BT extends BeanType<T>> Collection<BT> filter(Class<T> beanType, Collection<BT> candidates) {
        return this.filterArgumentTypeParameters(this.argument, candidates, null);
    }

    private boolean matchesArgumentTypeParameters(Argument<?> argument, Argument<?> candidateArgument) {
        Argument[] candidateTypeParameters;
        Argument[] argumentTypeParameters = argument.getTypeParameters();
        if (argumentTypeParameters.length != (candidateTypeParameters = candidateArgument.getTypeParameters()).length) {
            if (argumentTypeParameters.length == 0) {
                for (Argument candidateTypeParameter : candidateTypeParameters) {
                    if (candidateTypeParameter.getType().equals(Object.class)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        for (int i = 0; i < candidateTypeParameters.length; ++i) {
            Argument typeParameter = argumentTypeParameters[i];
            Argument candidateTypeParameter = candidateTypeParameters[i];
            if (this.doesMatch(candidateTypeParameter, candidateTypeParameter.getType(), typeParameter, typeParameter.getType())) continue;
            return false;
        }
        return true;
    }

    private <BT extends BeanType<T>> Collection<BT> filterArgumentTypeParameters(Argument<?> argument, Collection<BT> result, Function<BT, Argument<?>> typeArgumentExtractor) {
        Argument[] typeParameters = argument.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            int finalI = i;
            Argument typeParameter = typeParameters[i];
            Function<BeanType, Argument> getCandidateArgumentFunction = bd -> {
                if (typeArgumentExtractor == null) {
                    if (bd instanceof BeanDefinition) {
                        BeanDefinition beanDefinition = (BeanDefinition)bd;
                        List typeArguments = beanDefinition.getTypeArguments(argument.getType());
                        return typeArguments.get(finalI);
                    }
                    return null;
                }
                Argument apply = (Argument)typeArgumentExtractor.apply(bd);
                Argument[] candidateTypeParameters = apply.getTypeParameters();
                if (finalI < candidateTypeParameters.length) {
                    return candidateTypeParameters[finalI];
                }
                return Argument.OBJECT_ARGUMENT;
            };
            result = this.filterMatching(typeParameter, result, getCandidateArgumentFunction);
            result = this.filterArgumentTypeParameters(typeParameter, result, getCandidateArgumentFunction);
        }
        return result;
    }

    private <BT extends BeanType<T>> List<BT> filterMatching(Argument<?> argument, Collection<BT> candidates, Function<BT, Argument<?>> typeArgumentExtractor) {
        ArrayList<BeanType> selectedDirect = null;
        boolean directMatch = false;
        ArrayList<Map.Entry> closestMatches = null;
        boolean interfaceCandidatePresent = false;
        boolean classCandidatePresent = false;
        block0: for (BeanType candidate : candidates) {
            boolean isClassCandidate;
            Argument<?> candidateArgument;
            Class candidateType;
            Class<Object> argumentTypeClass = argument.getType();
            if (argumentTypeClass.isPrimitive()) {
                argumentTypeClass = ReflectionUtils.getWrapperType(argumentTypeClass);
            }
            if (argumentTypeClass.equals(candidateType = (candidateArgument = typeArgumentExtractor.apply(candidate)).getType())) {
                if (!this.matchesArgumentTypeParameters(argument, candidateArgument)) {
                    MatchArgumentQualifier.reject(argument, candidate);
                    continue;
                }
                if (!directMatch) {
                    selectedDirect = new ArrayList<BeanType>(3);
                    closestMatches = null;
                    directMatch = true;
                }
                selectedDirect.add(candidate);
                continue;
            }
            if (directMatch) {
                MatchArgumentQualifier.reject(argument, candidate);
                continue;
            }
            if (!this.doesMatch(candidateArgument, candidateType, argument, argumentTypeClass)) {
                MatchArgumentQualifier.reject(argument, candidate);
                continue;
            }
            boolean bl = isClassCandidate = !candidateType.isInterface();
            if (closestMatches != null) {
                if (isClassCandidate) {
                    if (interfaceCandidatePresent) {
                        closestMatches.removeIf(e -> {
                            boolean anInterface = ((Class)e.getKey()).isInterface();
                            if (anInterface && LOG.isTraceEnabled()) {
                                for (BeanType bt : (List)e.getValue()) {
                                    MatchArgumentQualifier.reject(argument, bt);
                                }
                            }
                            return anInterface;
                        });
                        interfaceCandidatePresent = false;
                    }
                    classCandidatePresent = true;
                } else if (classCandidatePresent) continue;
                Iterator iterator = closestMatches.iterator();
                while (iterator.hasNext()) {
                    Map.Entry e2 = (Map.Entry)iterator.next();
                    Class closestMatch = (Class)e2.getKey();
                    List selected = (List)e2.getValue();
                    if (closestMatch.equals(candidateType)) {
                        selected.add(candidate);
                        continue block0;
                    }
                    if (closestMatch.isAssignableFrom(candidateType)) {
                        iterator.remove();
                        if (LOG.isTraceEnabled()) {
                            for (BeanType bt : selected) {
                                MatchArgumentQualifier.reject(argument, bt);
                            }
                        }
                        ArrayList<BeanType> newSelected = new ArrayList<BeanType>();
                        newSelected.add(candidate);
                        closestMatches.add(new AbstractMap.SimpleEntry(candidateType, newSelected));
                        continue block0;
                    }
                    if (!candidateType.isAssignableFrom(closestMatch)) continue;
                    MatchArgumentQualifier.reject(argument, candidate);
                    continue block0;
                }
            } else {
                closestMatches = new ArrayList<Map.Entry>();
            }
            classCandidatePresent = isClassCandidate;
            interfaceCandidatePresent = !isClassCandidate;
            ArrayList<BeanType> newSelected = new ArrayList<BeanType>();
            newSelected.add(candidate);
            closestMatches.add(new AbstractMap.SimpleEntry(candidateType, newSelected));
        }
        if (directMatch) {
            return selectedDirect;
        }
        if (closestMatches != null) {
            if (closestMatches.size() == 1) {
                return (List)((Map.Entry)closestMatches.iterator().next()).getValue();
            }
            ArrayList result = new ArrayList();
            for (Map.Entry match : closestMatches) {
                result.addAll((Collection)match.getValue());
            }
            return result;
        }
        return List.of();
    }

    private boolean doesMatch(Argument<?> candidateArgument, Class<?> candidateType, Argument<?> argument, Class<?> argumentType) {
        if (candidateType.equals(argumentType)) {
            return true;
        }
        if (candidateType.equals(Enum.class)) {
            return candidateType.isAssignableFrom(argumentType);
        }
        if (argument.isTypeVariable()) {
            if (argument == this.superArgument) {
                if (candidateArgument.isTypeVariable() && candidateType.isAssignableFrom(argumentType)) {
                    return true;
                }
                return argumentType.isAssignableFrom(candidateType);
            }
            return candidateType.isAssignableFrom(argumentType);
        }
        if (candidateType.equals(Object.class)) {
            return true;
        }
        if (!candidateArgument.isTypeVariable()) {
            return false;
        }
        return candidateType.isAssignableFrom(argumentType);
    }

    private static <BT extends BeanType<?>> void reject(Argument<?> argument, BT candidate) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Bean candidate {} is not compatible with an argument {}", (Object)candidate, (Object)argument);
        }
    }
}

