/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.sse.Event;
import io.micronaut.scheduling.executor.ThreadSelection;
import io.micronaut.web.router.RouteInfo;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

@Internal
public class DefaultRouteInfo<R>
implements RouteInfo<R> {
    protected final ReturnType<? extends R> returnType;
    protected final List<MediaType> consumesMediaTypes;
    protected final List<MediaType> producesMediaTypes;
    protected final AnnotationMetadata annotationMetadata;
    protected final Class<?> declaringType;
    protected final boolean consumesMediaTypesContainsAll;
    protected final boolean producesMediaTypesContainsAll;
    @Nullable
    protected final HttpStatus definedStatus;
    protected final boolean isWebSocketRoute;
    private final boolean isVoid;
    private final boolean imperative;
    private final boolean suspended;
    private final boolean reactive;
    private final boolean single;
    private final boolean async;
    private final boolean completable;
    private final boolean specifiedSingle;
    private final boolean asyncOrReactive;
    private final Argument<?> bodyType;
    private final boolean isErrorRoute;
    private final boolean isPermitsBody;
    private final MessageBodyWriter<R> messageBodyWriter;

    public DefaultRouteInfo(ReturnType<? extends R> returnType, Class<?> declaringType, boolean isErrorRoute, boolean isPermitsBody) {
        this(AnnotationMetadata.EMPTY_METADATA, returnType, List.of(), List.of(), declaringType, isErrorRoute, isPermitsBody, MessageBodyHandlerRegistry.EMPTY);
    }

    public DefaultRouteInfo(AnnotationMetadata annotationMetadata, ReturnType<? extends R> returnType, List<MediaType> consumesMediaTypes, List<MediaType> producesMediaTypes, Class<?> declaringType, boolean isErrorRoute, boolean isPermitsBody, MessageBodyHandlerRegistry messageBodyHandlerRegistry) {
        this.annotationMetadata = annotationMetadata;
        this.returnType = returnType;
        this.bodyType = DefaultRouteInfo.resolveBodyType(returnType);
        this.messageBodyWriter = messageBodyHandlerRegistry.findWriter(this.bodyType, producesMediaTypes).map(w -> w.createSpecific(this.bodyType)).orElse(null);
        this.single = returnType.isSingleResult() || this.isReactive() && returnType.getFirstTypeVariable().filter(t2 -> HttpResponse.class.isAssignableFrom(t2.getType())).isPresent() || returnType.isAsync() || returnType.isSuspended();
        this.specifiedSingle = returnType.isSpecifiedSingle();
        this.completable = returnType.isCompletable();
        this.async = returnType.isAsync();
        this.asyncOrReactive = returnType.isAsyncOrReactive();
        this.reactive = returnType.isReactive();
        this.suspended = returnType.isSuspended();
        this.declaringType = declaringType;
        this.isErrorRoute = isErrorRoute;
        this.isPermitsBody = isPermitsBody;
        this.isVoid = returnType.isVoid();
        this.isWebSocketRoute = annotationMetadata.hasAnnotation("io.micronaut.websocket.annotation.OnMessage");
        this.definedStatus = annotationMetadata.enumValue(Status.class, HttpStatus.class).orElse(null);
        if (producesMediaTypes.isEmpty()) {
            Object[] producesTypes = MediaType.of(annotationMetadata.stringValues(Produces.class));
            Optional<Argument<?>> firstTypeVariable = returnType.getFirstTypeVariable();
            if (firstTypeVariable.isPresent() && Event.class.isAssignableFrom(firstTypeVariable.get().getType())) {
                this.producesMediaTypes = List.of(MediaType.TEXT_EVENT_STREAM_TYPE);
                this.producesMediaTypesContainsAll = true;
            } else if (ArrayUtils.isNotEmpty(producesTypes)) {
                this.producesMediaTypes = List.of(producesTypes);
                this.producesMediaTypesContainsAll = this.producesMediaTypes.contains(MediaType.ALL_TYPE);
            } else {
                this.producesMediaTypesContainsAll = true;
                this.producesMediaTypes = RouteInfo.DEFAULT_PRODUCES;
            }
        } else {
            this.producesMediaTypes = producesMediaTypes;
            this.producesMediaTypesContainsAll = this.producesMediaTypes.contains(MediaType.ALL_TYPE);
        }
        if (consumesMediaTypes.isEmpty()) {
            Object[] consumesTypes = MediaType.of(annotationMetadata.stringValues(Consumes.class));
            if (ArrayUtils.isNotEmpty(consumesTypes)) {
                this.consumesMediaTypes = List.of(consumesTypes);
                this.consumesMediaTypesContainsAll = this.consumesMediaTypes.contains(MediaType.ALL_TYPE);
            } else {
                this.consumesMediaTypes = List.of();
                this.consumesMediaTypesContainsAll = true;
            }
        } else {
            this.consumesMediaTypes = consumesMediaTypes;
            this.consumesMediaTypesContainsAll = this.consumesMediaTypes.contains(MediaType.ALL_TYPE);
        }
        this.imperative = returnType.getType() == Void.TYPE && !this.suspended || !this.suspended && !this.reactive && !this.async && !returnType.getType().equals(Object.class) && (returnType.getType().getPackageName().startsWith("java.") || BeanIntrospector.SHARED.findIntrospection(returnType.getType()).isPresent());
    }

    @Override
    public MessageBodyWriter<R> getMessageBodyWriter() {
        return this.messageBodyWriter;
    }

    private static Argument<?> resolveBodyType(ReturnType<?> returnType) {
        if (returnType.isAsyncOrReactive()) {
            Argument<Object> reactiveType = returnType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            if (HttpResponse.class.isAssignableFrom(reactiveType.getType())) {
                reactiveType = reactiveType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            }
            return reactiveType;
        }
        if (HttpResponse.class.isAssignableFrom(returnType.getType())) {
            Argument<Object> responseType = returnType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            if (responseType.isAsyncOrReactive()) {
                return responseType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            }
            return responseType;
        }
        return returnType.asArgument();
    }

    @Override
    public Optional<Argument<?>> getRequestBodyType() {
        return Optional.empty();
    }

    @Override
    public ReturnType<? extends R> getReturnType() {
        return this.returnType;
    }

    @Override
    public Argument<?> getResponseBodyType() {
        return this.bodyType;
    }

    @Override
    public Class<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public List<MediaType> getProduces() {
        return this.producesMediaTypes;
    }

    @Override
    public List<MediaType> getConsumes() {
        return this.consumesMediaTypes;
    }

    @Override
    public boolean consumesAll() {
        return this.consumesMediaTypesContainsAll;
    }

    @Override
    public boolean doesConsume(MediaType contentType) {
        return contentType == null || this.consumesMediaTypesContainsAll || this.explicitlyConsumes(contentType);
    }

    @Override
    public boolean producesAll() {
        return this.producesMediaTypesContainsAll;
    }

    @Override
    public boolean doesProduce(@Nullable Collection<MediaType> acceptableTypes) {
        return this.producesMediaTypesContainsAll || this.anyMediaTypesMatch(this.producesMediaTypes, acceptableTypes);
    }

    @Override
    public boolean doesProduce(@Nullable MediaType acceptableType) {
        return this.producesMediaTypesContainsAll || acceptableType == null || acceptableType.equals(MediaType.ALL_TYPE) || this.producesMediaTypes.contains(acceptableType);
    }

    private boolean anyMediaTypesMatch(List<MediaType> producedMediaTypes, Collection<MediaType> acceptableTypes) {
        if (CollectionUtils.isEmpty(acceptableTypes)) {
            return true;
        }
        for (MediaType acceptableType : acceptableTypes) {
            if (!acceptableType.equals(MediaType.ALL_TYPE) && !producedMediaTypes.contains(acceptableType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean explicitlyConsumes(MediaType contentType) {
        return this.consumesMediaTypes.contains(contentType);
    }

    @Override
    public boolean explicitlyProduces(MediaType contentType) {
        return this.producesMediaTypes == null || this.producesMediaTypes.isEmpty() || this.producesMediaTypes.contains(contentType);
    }

    @Override
    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    public boolean isImperative() {
        return this.imperative;
    }

    @Override
    public boolean isReactive() {
        return this.reactive;
    }

    @Override
    public boolean isSingleResult() {
        return this.single;
    }

    @Override
    public boolean isSpecifiedSingle() {
        return this.specifiedSingle;
    }

    @Override
    public boolean isCompletable() {
        return this.completable;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    @Override
    public boolean isAsyncOrReactive() {
        return this.asyncOrReactive;
    }

    @Override
    public boolean isVoid() {
        return this.isVoid;
    }

    @Override
    public HttpStatus findStatus(HttpStatus defaultStatus) {
        if (this.definedStatus != null) {
            return this.definedStatus;
        }
        if (defaultStatus != null) {
            return defaultStatus;
        }
        return HttpStatus.OK;
    }

    @Override
    public boolean isErrorRoute() {
        return this.isErrorRoute;
    }

    @Override
    public boolean isWebSocketRoute() {
        return this.isWebSocketRoute;
    }

    @Override
    public boolean isPermitsRequestBody() {
        return this.isPermitsBody;
    }

    @Override
    public ExecutorService getExecutor(ThreadSelection threadSelection) {
        return null;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public boolean needsRequestBody() {
        return this.isPermitsBody;
    }
}

