/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArrayUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

@Internal
public record MatchesEnvironmentCondition(String[] env) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext) {
            ApplicationContext applicationContext = (ApplicationContext)beanContext;
            Environment environment = applicationContext.getEnvironment();
            Set<String> activeNames = environment.getActiveNames();
            boolean result = this.matches(activeNames);
            if (!result) {
                context.fail("None of the required environments [" + ArrayUtils.toString(this.env) + "] are active: " + activeNames);
            }
            return result;
        }
        return true;
    }

    private boolean matches(Set<String> activeNames) {
        for (String s2 : this.env) {
            if (!activeNames.contains(s2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesEnvironmentCondition that = (MatchesEnvironmentCondition)o;
        return Objects.deepEquals(this.env, that.env);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.env);
    }

    @Override
    public String toString() {
        return "MatchesEnvironmentCondition{env=" + Arrays.toString(this.env) + "}";
    }
}

