/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionServiceAware;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpMessage;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.uri.UriBuilder;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public interface MutableHttpRequest<B>
extends HttpRequest<B>,
MutableHttpMessage<B>,
ConversionServiceAware {
    public MutableHttpRequest<B> cookie(Cookie var1);

    default public MutableHttpRequest<B> cookies(Set<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            this.cookie(cookie);
        }
        return this;
    }

    public MutableHttpRequest<B> uri(URI var1);

    @Override
    public <T> MutableHttpRequest<T> body(T var1);

    @Override
    public MutableHttpHeaders getHeaders();

    @Override
    public MutableHttpParameters getParameters();

    @NonNull
    default public MutableHttpRequest<B> uri(@NonNull Consumer<UriBuilder> consumer) {
        Objects.requireNonNull(consumer, "URI builder cannot be null");
        UriBuilder builder = UriBuilder.of(this.getUri());
        consumer.accept(builder);
        return this.uri(builder.build());
    }

    default public MutableHttpRequest<B> accept(MediaType ... mediaTypes) {
        if (ArrayUtils.isNotEmpty(mediaTypes)) {
            String acceptString = String.join((CharSequence)",", mediaTypes);
            this.header("Accept", acceptString);
        }
        return this;
    }

    default public MutableHttpRequest<B> accept(CharSequence ... mediaTypes) {
        if (ArrayUtils.isNotEmpty(mediaTypes)) {
            String acceptString = String.join((CharSequence)",", mediaTypes);
            this.header("Accept", acceptString);
        }
        return this;
    }

    @Override
    default public MutableHttpRequest<B> headers(Consumer<MutableHttpHeaders> headers) {
        return (MutableHttpRequest)MutableHttpMessage.super.headers(headers);
    }

    @Override
    default public MutableHttpRequest<B> header(CharSequence name, CharSequence value) {
        return (MutableHttpRequest)MutableHttpMessage.super.header(name, value);
    }

    @Override
    default public MutableHttpRequest<B> basicAuth(CharSequence username, CharSequence password) {
        return (MutableHttpRequest)MutableHttpMessage.super.basicAuth(username, password);
    }

    @Override
    default public MutableHttpRequest<B> bearerAuth(CharSequence token) {
        return (MutableHttpRequest)MutableHttpMessage.super.bearerAuth(token);
    }

    @Override
    default public MutableHttpRequest<B> headers(Map<CharSequence, CharSequence> namesAndValues) {
        return (MutableHttpRequest)MutableHttpMessage.super.headers(namesAndValues);
    }

    @Override
    default public MutableHttpRequest<B> contentLength(long length) {
        return (MutableHttpRequest)MutableHttpMessage.super.contentLength(length);
    }

    @Override
    default public MutableHttpRequest<B> contentType(CharSequence contentType) {
        return (MutableHttpRequest)MutableHttpMessage.super.contentType(contentType);
    }

    @Override
    default public MutableHttpRequest<B> contentType(MediaType mediaType) {
        return (MutableHttpRequest)MutableHttpMessage.super.contentType(mediaType);
    }

    @Override
    default public MutableHttpRequest<B> contentEncoding(CharSequence encoding) {
        return (MutableHttpRequest)MutableHttpMessage.super.contentEncoding(encoding);
    }

    @Override
    default public MutableHttpRequest<B> toMutableRequest() {
        return this;
    }
}

