/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.DelayedSubscriber;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.MediaTypeProvider;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.context.ServerHttpRequestContext;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.netty.EventLoopFlow;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.body.NettyBodyWriter;
import io.micronaut.http.netty.body.NettyJsonHandler;
import io.micronaut.http.netty.body.NettyWriteContext;
import io.micronaut.http.netty.stream.JsonSubscriber;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.netty.DelegateStreamedHttpResponse;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyRequestLifecycle;
import io.micronaut.http.server.netty.body.AvailableNettyByteBody;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.handler.OutboundAccess;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.micronaut.web.router.DefaultUrlRouteInfo;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Internal
@ChannelHandler.Sharable
public final class RoutingInBoundHandler
implements RequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingInBoundHandler.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection (?:reset|closed|abort|broken)|broken pipe).*$", 2);
    final StaticResourceResolver staticResourceResolver;
    final NettyHttpServerConfiguration serverConfiguration;
    final RequestArgumentSatisfier requestArgumentSatisfier;
    final Supplier<ExecutorService> ioExecutorSupplier;
    final boolean multipartEnabled;
    final MessageBodyHandlerRegistry messageBodyHandlerRegistry;
    ExecutorService ioExecutor;
    final ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher;
    final RouteExecutor routeExecutor;
    final ConversionService conversionService;
    boolean supportLoggingHandler = false;

    RoutingInBoundHandler(NettyHttpServerConfiguration serverConfiguration, NettyEmbeddedServices embeddedServerContext, Supplier<ExecutorService> ioExecutor, ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher, ConversionService conversionService) {
        this.staticResourceResolver = embeddedServerContext.getStaticResourceResolver();
        this.messageBodyHandlerRegistry = embeddedServerContext.getMessageBodyHandlerRegistry();
        this.ioExecutorSupplier = ioExecutor;
        this.requestArgumentSatisfier = embeddedServerContext.getRequestArgumentSatisfier();
        this.serverConfiguration = serverConfiguration;
        this.terminateEventPublisher = terminateEventPublisher;
        Optional<Boolean> isMultiPartEnabled = serverConfiguration.getMultipart().getEnabled();
        this.multipartEnabled = isMultiPartEnabled.isEmpty() || isMultiPartEnabled.get() != false;
        this.routeExecutor = embeddedServerContext.getRouteExecutor();
        this.conversionService = conversionService;
    }

    private void cleanupRequest(NettyHttpRequest<?> request) {
        try {
            request.release();
        }
        finally {
            block9: {
                if (!this.terminateEventPublisher.isEmpty()) {
                    try {
                        this.terminateEventPublisher.publishEvent(new HttpRequestTerminatedEvent(request));
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) break block9;
                        LOG.error("Error publishing request terminated event: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        }
    }

    @Override
    public void responseWritten(Object attachment) {
        if (attachment != null) {
            this.cleanupRequest((NettyHttpRequest)attachment);
        }
    }

    @Override
    public void handleUnboundError(Throwable cause) {
        if (this.isIgnorable(cause)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Swallowed an IOException caused by client connectivity: {}", (Object)cause.getMessage(), (Object)cause);
            }
            return;
        }
        if (cause instanceof SSLException || cause.getCause() instanceof SSLException || cause instanceof DecompressionException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Micronaut Server Error - No request state present. Cause: {}", (Object)cause.getMessage(), (Object)cause);
            }
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Micronaut Server Error - No request state present. Cause: {}", (Object)cause.getMessage(), (Object)cause);
        }
    }

    @Override
    public void accept(ChannelHandlerContext ctx, io.netty.handler.codec.http.HttpRequest request, CloseableByteBody body, OutboundAccess outboundAccess) {
        NettyHttpRequest mnRequest = new NettyHttpRequest(request, body, ctx, this.conversionService, this.serverConfiguration);
        if (this.serverConfiguration.isValidateUrl()) {
            try {
                mnRequest.getUri();
            }
            catch (IllegalArgumentException e) {
                body.close();
                NettyHttpRequest errorRequest = new NettyHttpRequest(new DefaultHttpRequest(request.protocolVersion(), request.method(), "/"), AvailableNettyByteBody.empty(), ctx, this.conversionService, this.serverConfiguration);
                outboundAccess.attachment(errorRequest);
                try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus(new ServerHttpRequestContext(errorRequest)).propagate();){
                    new NettyRequestLifecycle(this, outboundAccess).handleException(errorRequest, e.getCause() == null ? e : e.getCause());
                }
                return;
            }
        }
        if (this.supportLoggingHandler && ctx.pipeline().get("http-access-logger") != null) {
            AttributeKey key = AttributeKey.valueOf(NettyHttpRequest.class.getSimpleName());
            ctx.channel().attr(key).set(mnRequest);
        }
        outboundAccess.attachment(mnRequest);
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus(new ServerHttpRequestContext(mnRequest)).propagate();){
            new NettyRequestLifecycle(this, outboundAccess).handleNormal(mnRequest);
        }
    }

    public void writeResponse(OutboundAccess outboundAccess, NettyHttpRequest<?> nettyHttpRequest, HttpResponse<?> response, Throwable throwable) {
        if (throwable != null) {
            response = this.routeExecutor.createDefaultErrorResponse(nettyHttpRequest, throwable);
        }
        if (response != null) {
            try {
                this.encodeHttpResponse(outboundAccess, nettyHttpRequest, response, response.body());
            }
            catch (Throwable e) {
                try {
                    response = this.routeExecutor.createDefaultErrorResponse(nettyHttpRequest, e);
                    this.encodeHttpResponse(outboundAccess, nettyHttpRequest, response, response.body());
                }
                catch (Throwable f) {
                    f.addSuppressed(e);
                    outboundAccess.closeAfterWrite();
                    try {
                        outboundAccess.writeFull(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.EMPTY_BUFFER));
                    }
                    catch (Throwable g2) {
                        f.addSuppressed(g2);
                    }
                    LOG.warn("Failed to encode error response", f);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getIoExecutor() {
        ExecutorService executor = this.ioExecutor;
        if (executor == null) {
            RoutingInBoundHandler routingInBoundHandler = this;
            synchronized (routingInBoundHandler) {
                executor = this.ioExecutor;
                if (executor == null) {
                    this.ioExecutor = executor = this.ioExecutorSupplier.get();
                }
            }
        }
        return executor;
    }

    private void encodeHttpResponse(OutboundAccess outboundAccess, NettyHttpRequest<?> nettyRequest, HttpResponse<?> httpResponse, Object body) {
        MutableHttpResponse<Object> response = httpResponse.toMutableResponse();
        if (nettyRequest.getMethod() != HttpMethod.HEAD && body != null) {
            MessageBodyWriter<?> messageBodyWriter;
            RouteInfo routeInfo;
            Object routeInfoO = response.getAttribute(HttpAttributes.ROUTE_INFO).orElse(null);
            if (routeInfoO instanceof DefaultUrlRouteInfo) {
                DefaultUrlRouteInfo uri = routeInfoO;
                v0 = uri;
            } else {
                v0 = routeInfo = (RouteInfo)routeInfoO;
            }
            if (Publishers.isConvertibleToPublisher(body)) {
                response.body((Object)null);
                DelegateStreamedHttpResponse streamedResponse = new DelegateStreamedHttpResponse(this.toNettyResponse(response), this.mapToHttpContent(nettyRequest, response, body, routeInfo, nettyRequest.getChannelHandlerContext()));
                this.writeStreamedWithErrorHandling(nettyRequest, outboundAccess, streamedResponse);
                return;
            }
            Object o = response.getBodyWriter().orElse(null);
            if (o instanceof NettyJsonHandler) {
                NettyJsonHandler njh = o;
                messageBodyWriter = njh;
            } else {
                messageBodyWriter = o;
            }
            MessageBodyWriter<?> messageBodyWriter2 = messageBodyWriter;
            MediaType responseMediaType = response.getContentType().orElse(null);
            Argument<Object> responseBodyType = routeInfo != null ? routeInfo.getResponseBodyType() : Argument.of(body.getClass());
            if (responseMediaType == null) {
                if (!(body instanceof String) && !(body instanceof byte[]) && body instanceof MediaTypeProvider) {
                    MediaTypeProvider mediaTypeProvider = (MediaTypeProvider)body;
                    responseMediaType = mediaTypeProvider.getMediaType();
                } else {
                    responseMediaType = routeInfo != null ? this.routeExecutor.resolveDefaultResponseContentType(nettyRequest, routeInfo) : MediaType.APPLICATION_JSON_TYPE;
                }
            }
            if (messageBodyWriter2 == null) {
                messageBodyWriter2 = this.messageBodyHandlerRegistry.findWriter(responseBodyType, Collections.singletonList(responseMediaType)).orElse(null);
            }
            if (messageBodyWriter2 == null || !responseBodyType.isInstance(body) || !messageBodyWriter2.isWriteable(responseBodyType, responseMediaType)) {
                responseBodyType = Argument.ofInstance(body);
                messageBodyWriter2 = this.messageBodyHandlerRegistry.getWriter(responseBodyType, List.of(responseMediaType));
            }
            NettyBodyWriter<Object> closure = this.wrap(messageBodyWriter2);
            this.closeConnectionIfError(response, nettyRequest, outboundAccess);
            if (closure.isBlocking()) {
                MediaType finalResponseMediaType = responseMediaType;
                Argument<Object> finalResponseBodyType = responseBodyType;
                this.getIoExecutor().execute(() -> this.writeNettyMessageBody(nettyRequest, response, finalResponseBodyType, finalResponseMediaType, body, closure, outboundAccess, true));
            } else {
                this.writeNettyMessageBody(nettyRequest, response, responseBodyType, responseMediaType, body, closure, outboundAccess, false);
            }
        } else {
            response.body((Object)null);
            this.writeFinalNettyResponse(response, nettyRequest, outboundAccess);
        }
    }

    private void writeNettyMessageBody(NettyHttpRequest<?> nettyRequest, MutableHttpResponse<Object> response, Argument<Object> responseBodyType, MediaType mediaType, Object body, NettyBodyWriter<Object> nettyMessageBodyWriter, OutboundAccess outboundAccess, boolean onIoExecutor) {
        try {
            nettyMessageBodyWriter.writeTo(nettyRequest, response, responseBodyType, mediaType, body, outboundAccess);
        }
        catch (CodecException e) {
            MutableHttpResponse<Object> errorResponse = this.routeExecutor.createDefaultErrorResponse(nettyRequest, e);
            this.writeError(nettyRequest, outboundAccess, onIoExecutor, errorResponse);
        }
    }

    private void writeError(NettyHttpRequest<?> nettyRequest, OutboundAccess outboundAccess, boolean onIoExecutor, MutableHttpResponse<Object> errorResponse) {
        Object errorBody = errorResponse.body();
        Argument type = Argument.ofInstance(errorBody);
        MediaType errorContentType = errorResponse.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        MessageBodyWriter messageBodyWriter = this.messageBodyHandlerRegistry.getWriter(type, List.of(errorContentType));
        NettyBodyWriter nettyWriter = this.wrap(messageBodyWriter);
        if (onIoExecutor || !nettyWriter.isBlocking()) {
            nettyWriter.writeTo(nettyRequest, errorResponse, type, errorContentType, errorBody, outboundAccess);
        } else {
            this.ioExecutor.execute(() -> nettyWriter.writeTo(nettyRequest, errorResponse, type, errorContentType, errorBody, outboundAccess));
        }
    }

    private Flux<HttpContent> mapToHttpContent(NettyHttpRequest<?> request, MutableHttpResponse<?> response, Object body, RouteInfo<Object> routeInfo, ChannelHandlerContext context) {
        Flux<HttpContent> httpContentPublisher;
        MediaType mediaType = response.getContentType().orElse(null);
        NettyByteBufferFactory byteBufferFactory = new NettyByteBufferFactory(context.alloc());
        Flux<Object> bodyPublisher = Flux.from(Publishers.convertToPublisher(this.conversionService, body));
        boolean isJson = false;
        if (routeInfo != null) {
            if (mediaType == null) {
                mediaType = this.routeExecutor.resolveDefaultResponseContentType(request, routeInfo);
            }
            isJson = mediaType != null && mediaType.getExtension().equals("json") && routeInfo.isResponseBodyJsonFormattable();
            MediaType finalMediaType = mediaType;
            httpContentPublisher = bodyPublisher.concatMap(message -> {
                MessageBodyWriter<Object> messageBodyWriter = routeInfo.getMessageBodyWriter();
                Argument<Object> responseBodyType = routeInfo.getResponseBodyType();
                if (messageBodyWriter == null || !responseBodyType.isInstance(message) || !messageBodyWriter.isWriteable(responseBodyType, finalMediaType)) {
                    responseBodyType = Argument.ofInstance(message);
                    messageBodyWriter = this.messageBodyHandlerRegistry.getWriter(responseBodyType, List.of(finalMediaType));
                }
                return this.writeAsync(messageBodyWriter, responseBodyType, finalMediaType, message, (MutableHeaders)((Object)response.getHeaders()), byteBufferFactory);
            }).map(byteBuffer -> new DefaultHttpContent((ByteBuf)byteBuffer.asNativeBuffer()));
        } else {
            MediaType finalMediaType = mediaType;
            httpContentPublisher = bodyPublisher.concatMap(message -> {
                Argument<Object> type = Argument.ofInstance(message);
                MessageBodyWriter<Object> messageBodyWriter = this.messageBodyHandlerRegistry.getWriter(type, finalMediaType == null ? List.of() : List.of(finalMediaType));
                return this.writeAsync(messageBodyWriter, type, finalMediaType, message, (MutableHeaders)((Object)response.getHeaders()), byteBufferFactory);
            }).map(byteBuffer -> new DefaultHttpContent((ByteBuf)byteBuffer.asNativeBuffer()));
        }
        if (isJson) {
            httpContentPublisher = JsonSubscriber.lift(httpContentPublisher);
        }
        httpContentPublisher = httpContentPublisher.contextWrite(reactorContext -> reactorContext.put("micronaut.http.server.request", request));
        return httpContentPublisher;
    }

    private <T> Publisher<ByteBuffer<?>> writeAsync(@NonNull MessageBodyWriter<T> messageBodyWriter, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object, @NonNull MutableHeaders outgoingHeaders, @NonNull ByteBufferFactory<?, ?> bufferFactory) {
        if (messageBodyWriter.isBlocking()) {
            return Mono.defer(() -> Mono.just(messageBodyWriter.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory))).subscribeOn(Schedulers.fromExecutor(this.ioExecutor));
        }
        return Mono.just(messageBodyWriter.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory));
    }

    private void writeFinalNettyResponse(MutableHttpResponse<?> message, NettyHttpRequest<?> request, OutboundAccess outboundAccess) {
        this.closeConnectionIfError(message, request, outboundAccess);
        io.netty.handler.codec.http.HttpResponse nettyResponse = NettyHttpResponseBuilder.toHttpResponse(message);
        if (nettyResponse instanceof StreamedHttpResponse) {
            StreamedHttpResponse streamed = (StreamedHttpResponse)nettyResponse;
            this.writeStreamedWithErrorHandling(request, outboundAccess, streamed);
        } else {
            FullHttpResponse fullResponse = (FullHttpResponse)nettyResponse;
            outboundAccess.writeFull(fullResponse, request.getMethod() == HttpMethod.HEAD);
        }
        this.log(request, nettyResponse);
    }

    private void writeFinalFullNettyResponse(MutableHttpResponse<?> message, NettyHttpRequest<?> request, OutboundAccess outboundAccess, ByteBuf byteBuf) {
        this.closeConnectionIfError(message, request, outboundAccess);
        FullHttpResponse fullResponse = NettyHttpResponseBuilder.toFullHttpResponse(message, byteBuf);
        outboundAccess.writeFull(fullResponse, request.getMethod() == HttpMethod.HEAD);
        this.log(request, fullResponse);
    }

    private void log(HttpRequest<?> request, io.netty.handler.codec.http.HttpResponse nettyResponse) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response {} - {} {}", nettyResponse.status().code(), request.getMethodName(), request.getUri());
        }
    }

    private void writeStreamedWithErrorHandling(NettyHttpRequest<?> request, OutboundAccess outboundAccess, StreamedHttpResponse streamed) {
        LazySendingSubscriber sub = new LazySendingSubscriber(request, streamed, outboundAccess);
        streamed.subscribe(sub);
    }

    private void closeConnectionIfError(MutableHttpResponse<?> message, HttpRequest<?> request, OutboundAccess outboundAccess) {
        NettyHttpRequest nettyRequest;
        boolean decodeError;
        boolean bl = decodeError = request instanceof NettyHttpRequest && (nettyRequest = (NettyHttpRequest)request).getNativeRequest().decoderResult().isFailure();
        if (decodeError || message.code() >= 500 && !this.serverConfiguration.isKeepAliveOnServerError()) {
            outboundAccess.closeAfterWrite();
        }
    }

    @NonNull
    private io.netty.handler.codec.http.HttpResponse toNettyResponse(HttpResponse<?> message) {
        if (message instanceof NettyHttpResponseBuilder) {
            NettyHttpResponseBuilder builder = (NettyHttpResponseBuilder)((Object)message);
            return builder.toHttpResponse();
        }
        return this.createNettyResponse(message).toHttpResponse();
    }

    @NonNull
    private NettyMutableHttpResponse<?> createNettyResponse(HttpResponse<?> message) {
        Object body = message.body();
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(this.serverConfiguration.isValidateHeaders());
        message.getHeaders().forEach(nettyHeaders::set);
        return new NettyMutableHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(message.code(), message.reason()), body instanceof ByteBuf ? body : null, this.conversionService);
    }

    boolean isIgnorable(Throwable cause) {
        if (cause instanceof ClosedChannelException || cause.getCause() instanceof ClosedChannelException) {
            return true;
        }
        String message = cause.getMessage();
        return cause instanceof IOException && message != null && IGNORABLE_ERROR_MESSAGE.matcher(message).matches();
    }

    <T> NettyBodyWriter<T> wrap(MessageBodyWriter<T> closure) {
        if (closure instanceof NettyJsonHandler) {
            NettyJsonHandler nettyClosure = (NettyJsonHandler)closure;
            return nettyClosure;
        }
        if (closure instanceof NettyBodyWriter) {
            NettyBodyWriter nettyClosure = (NettyBodyWriter)closure;
            return nettyClosure;
        }
        return new CompatNettyWriteClosure<T>(closure);
    }

    private final class LazySendingSubscriber
    implements Processor<HttpContent, HttpContent> {
        private static final Object COMPLETE = new Object();
        boolean headersSent = false;
        Subscription upstream;
        final DelayedSubscriber<HttpContent> downstream = new DelayedSubscriber();
        @Nullable
        HttpContent first;
        Object completion = null;
        private final EventLoopFlow flow;
        private final NettyHttpRequest<?> request;
        private final io.netty.handler.codec.http.HttpResponse headers;
        private final OutboundAccess outboundAccess;

        private LazySendingSubscriber(NettyHttpRequest<?> request, io.netty.handler.codec.http.HttpResponse headers, OutboundAccess outboundAccess) {
            this.request = request;
            this.headers = headers;
            this.outboundAccess = outboundAccess;
            this.flow = new EventLoopFlow(request.getChannelHandlerContext().channel().eventLoop());
        }

        @Override
        public void subscribe(final Subscriber<? super HttpContent> s2) {
            this.downstream.onSubscribe(new Subscription(){

                @Override
                public void request(long n) {
                    HttpContent first = LazySendingSubscriber.this.first;
                    if (first != null) {
                        LazySendingSubscriber.this.first = null;
                        s2.onNext(first);
                        if (LazySendingSubscriber.this.completion != null) {
                            if (LazySendingSubscriber.this.completion == COMPLETE) {
                                s2.onComplete();
                            } else {
                                s2.onError((Throwable)LazySendingSubscriber.this.completion);
                            }
                            return;
                        }
                        if (n != Long.MAX_VALUE && --n == 0L) {
                            return;
                        }
                    }
                    LazySendingSubscriber.this.upstream.request(n);
                }

                @Override
                public void cancel() {
                    if (LazySendingSubscriber.this.first != null) {
                        LazySendingSubscriber.this.first.release();
                        LazySendingSubscriber.this.first = null;
                    }
                    LazySendingSubscriber.this.upstream.cancel();
                }
            });
            this.downstream.subscribe(s2);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            this.upstream = s2;
            s2.request(1L);
        }

        @Override
        public void onNext(HttpContent httpContent) {
            if (this.flow.executeNow(() -> this.onNext0(httpContent))) {
                this.onNext0(httpContent);
            }
        }

        private void onNext0(HttpContent httpContent) {
            if (this.headersSent) {
                this.downstream.onNext(httpContent);
            } else {
                this.first = httpContent;
                this.headersSent = true;
                this.outboundAccess.writeStreamed(this.headers, this);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.flow.executeNow(() -> this.onError0(t2))) {
                this.onError0(t2);
            }
        }

        private void onError0(Throwable t2) {
            if (this.headersSent) {
                if (this.first != null) {
                    this.completion = t2;
                } else {
                    this.downstream.onError(t2);
                }
            } else {
                MutableHttpResponse<Object> response;
                if (t2 instanceof HttpStatusException) {
                    HttpStatusException hse = (HttpStatusException)t2;
                    response = HttpResponse.status(hse.getStatus());
                    if (hse.getBody().isPresent()) {
                        response.body(hse.getBody().get());
                    } else if (hse.getMessage() != null) {
                        response.body(hse.getMessage());
                    }
                } else {
                    response = RoutingInBoundHandler.this.routeExecutor.createDefaultErrorResponse(this.request, t2);
                }
                RoutingInBoundHandler.this.encodeHttpResponse(this.outboundAccess, this.request, response, response.body());
            }
        }

        @Override
        public void onComplete() {
            if (this.flow.executeNow(this::onComplete0)) {
                this.onComplete0();
            }
        }

        private void onComplete0() {
            if (this.headersSent) {
                if (this.first != null) {
                    this.completion = COMPLETE;
                } else {
                    this.downstream.onComplete();
                }
            } else {
                this.headersSent = true;
                this.outboundAccess.writeStreamed(this.headers, Flux.empty());
            }
        }
    }

    private final class CompatNettyWriteClosure<T>
    implements NettyBodyWriter<T> {
        private final MessageBodyWriter<T> delegate;

        CompatNettyWriteClosure(MessageBodyWriter<T> delegate) {
            assert (!(delegate instanceof NettyBodyWriter)) : "please create using wrap()";
            this.delegate = delegate;
        }

        @Override
        public boolean isBlocking() {
            return this.delegate.isBlocking();
        }

        @Override
        public void writeTo(HttpRequest<?> request, MutableHttpResponse<T> outgoingResponse, Argument<T> type, MediaType mediaType, T object, NettyWriteContext nettyContext) throws CodecException {
            NettyByteBufferFactory bufferFactory = new NettyByteBufferFactory(nettyContext.alloc());
            ByteBuffer<ByteBuf> byteBuffer = this.delegate.writeTo(type, mediaType, object, (MutableHeaders)((Object)outgoingResponse.getHeaders()), bufferFactory);
            ByteBuf buffer = byteBuffer.asNativeBuffer();
            RoutingInBoundHandler.this.writeFinalFullNettyResponse(outgoingResponse, (NettyHttpRequest)request, (OutboundAccess)nettyContext, buffer);
        }

        @Override
        public void writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
            this.delegate.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
        }

        @Override
        public ByteBuffer<?> writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
            return this.delegate.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory);
        }
    }
}

