/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Headers;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.bind.binders.PendingRequestBindingResult;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.context.ServerHttpRequestContext;
import io.micronaut.http.server.netty.FormDataHttpContentProcessor;
import io.micronaut.http.server.netty.FormRouteCompleter;
import io.micronaut.http.server.netty.MicronautHttpData;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.binders.NettyPartUploadAnnotationBinder;
import io.micronaut.http.server.netty.body.AvailableNettyByteBody;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.converters.NettyConverters;
import io.micronaut.web.router.RouteInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.CompositeByteBuf;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
final class NettyBodyAnnotationBinder<T>
extends DefaultBodyAnnotationBinder<T> {
    final NettyHttpServerConfiguration httpServerConfiguration;
    final MessageBodyHandlerRegistry bodyHandlerRegistry;

    NettyBodyAnnotationBinder(ConversionService conversionService, NettyHttpServerConfiguration httpServerConfiguration, MessageBodyHandlerRegistry bodyHandlerRegistry) {
        super(conversionService);
        this.httpServerConfiguration = httpServerConfiguration;
        this.bodyHandlerRegistry = bodyHandlerRegistry;
    }

    @Override
    protected ArgumentBinder.BindingResult<T> bindBodyPart(ArgumentConversionContext<T> context, HttpRequest<?> source, String bodyComponent) {
        NettyHttpRequest nhr;
        if (source instanceof NettyHttpRequest && (nhr = (NettyHttpRequest)source).isFormOrMultipartData()) {
            return NettyPartUploadAnnotationBinder.bindPart(this.conversionService, context, nhr, bodyComponent, true);
        }
        return super.bindBodyPart(context, source, bodyComponent);
    }

    @Override
    protected ArgumentBinder.BindingResult<ConvertibleValues<?>> bindFullBodyConvertibleValues(HttpRequest<?> source) {
        if (!(source instanceof NettyHttpRequest)) {
            return super.bindFullBodyConvertibleValues(source);
        }
        NettyHttpRequest nhr = (NettyHttpRequest)source;
        ArgumentBinder.BindingResult<ConvertibleValues<?>> existing = nhr.convertibleBody;
        if (existing != null) {
            return existing;
        }
        ArgumentBinder.BindingResult<ConvertibleValues<?>> result = this.bindFullBody(ConversionContext.of(ConvertibleValues.class), nhr);
        nhr.convertibleBody = result;
        return result;
    }

    @Override
    public ArgumentBinder.BindingResult<T> bindFullBody(final ArgumentConversionContext<T> context, HttpRequest<?> source) {
        if (!(source instanceof NettyHttpRequest)) {
            return super.bindFullBody(context, source);
        }
        final NettyHttpRequest nhr = (NettyHttpRequest)source;
        if (nhr.byteBody().expectedLength().orElse(-1L) == 0L) {
            return ArgumentBinder.BindingResult.empty();
        }
        CloseableByteBody body = nhr.byteBody().split(ByteBody.SplitBackpressureMode.FASTEST);
        final ExecutionFlow<? extends CloseableAvailableByteBody> buffered = InternalByteBody.bufferFlow(body);
        return new PendingRequestBindingResult<T>(){
            Optional<T> result;
            {
                nhr.addRouteWaitsFor(buffered.flatMap((? super T imm) -> {
                    PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus(new ServerHttpRequestContext(nhr)).propagate();
                    try {
                        this.result = NettyBodyAnnotationBinder.this.transform(nhr, context, (AvailableByteBody)imm);
                        ExecutionFlow<Object> executionFlow = ExecutionFlow.just(null);
                        if (ignore != null) {
                            ignore.close();
                        }
                        return executionFlow;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignore != null) {
                                try {
                                    ignore.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable e) {
                            return ExecutionFlow.error(e);
                        }
                    }
                }));
            }

            @Override
            public boolean isPending() {
                return this.result == null;
            }

            @Override
            public Optional<T> getValue() {
                return this.result;
            }

            @Override
            public List<ConversionError> getConversionErrors() {
                return context.getLastError().map(List::of).orElseGet(List::of);
            }
        };
    }

    Optional<T> transform(NettyHttpRequest<?> nhr, ArgumentConversionContext<T> context, AvailableByteBody imm) throws Throwable {
        MediaType mediaType;
        MessageBodyReader reader = null;
        RouteInfo routeInfo = nhr.getAttribute(HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
        if (routeInfo != null) {
            reader = routeInfo.getMessageBodyReader();
        }
        if (!((mediaType = (MediaType)nhr.getContentType().orElse(null)) == null || reader != null && reader.isReadable(context.getArgument(), mediaType))) {
            reader = this.bodyHandlerRegistry.findReader(context.getArgument(), List.of(mediaType)).orElse(null);
        }
        if (reader != null && context.getArgument().getType().equals(Object.class)) {
            reader = null;
        }
        if (reader == null && nhr.isFormOrMultipartData()) {
            Optional<Object> optional;
            Object intermediate;
            FormDataHttpContentProcessor processor = new FormDataHttpContentProcessor(nhr, this.httpServerConfiguration);
            ByteBuf buf = AvailableNettyByteBody.toByteBuf(imm);
            ArrayList data = new ArrayList();
            if (buf.isReadable()) {
                processor.add(new DefaultLastHttpContent(buf), data);
            } else {
                buf.release();
            }
            processor.complete(data);
            boolean allFormData = true;
            for (Object object : data) {
                if (object instanceof MicronautHttpData) continue;
                allFormData = false;
                break;
            }
            if (allFormData) {
                ArrayList formData = data;
                Map<String, Object> map = FormRouteCompleter.toMap(this.httpServerConfiguration.getDefaultCharset(), formData);
                for (MicronautHttpData datum : formData) {
                    datum.release();
                }
                intermediate = map;
            } else if (data.size() == 1) {
                intermediate = data.get(0);
                if (intermediate instanceof ByteBufHolder) {
                    ByteBufHolder bbh = (ByteBufHolder)intermediate;
                    intermediate = bbh.content();
                }
            } else {
                intermediate = NettyBodyAnnotationBinder.coerceToComposite(data, nhr.getChannelHandlerContext().alloc());
            }
            if (intermediate instanceof ReferenceCounted) {
                ReferenceCounted rc = (ReferenceCounted)intermediate;
                optional = NettyConverters.refCountAwareConvert(this.conversionService, rc, context);
            } else {
                optional = this.conversionService.convert(intermediate, context);
            }
            Optional<Object> converted = optional;
            nhr.setLegacyBody(converted.orElse(null));
            return converted;
        }
        ByteBuffer<?> byteBuffer = imm.toByteBuffer();
        if (reader != null) {
            T result = this.read(context, reader, nhr.getHeaders(), mediaType, byteBuffer);
            nhr.setLegacyBody(result);
            return Optional.ofNullable(result);
        }
        ByteBuf byteBuf = AvailableNettyByteBody.toByteBuf(imm);
        Optional<Object> converted = this.conversionService.convert(byteBuf, ByteBuf.class, context.getArgument().getType(), context);
        NettyConverters.postProcess(byteBuf, converted);
        nhr.setLegacyBody(converted.orElse(null));
        return converted;
    }

    private static CompositeByteBuf coerceToComposite(List<?> objects, ByteBufAllocator alloc) {
        CompositeByteBuf composite = alloc.compositeBuffer();
        for (Object object : objects) {
            composite.addComponent(true, (ByteBuf)object);
        }
        return composite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T read(ArgumentConversionContext<T> context, MessageBodyReader<T> reader, HttpHeaders headers, MediaType mediaType, ByteBuffer<?> byteBuffer) {
        Object rc;
        boolean success = false;
        try {
            T result = reader.read(context.getArgument(), mediaType, (Headers)headers, byteBuffer);
            success = true;
            T t2 = result;
            return t2;
        }
        catch (CodecException ce) {
            rc = ce.getCause();
            if (rc instanceof Exception) {
                Exception e = (Exception)rc;
                context.reject(e);
            } else {
                context.reject(ce);
            }
            T t3 = null;
            return t3;
        }
        finally {
            if (!success && byteBuffer instanceof io.micronaut.core.io.buffer.ReferenceCounted) {
                rc = (io.micronaut.core.io.buffer.ReferenceCounted)((Object)byteBuffer);
                rc.release();
            }
        }
    }
}

