/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.server.netty.body.NettyByteBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import reactor.core.publisher.Flux;

@Internal
public final class AvailableNettyByteBody
extends NettyByteBody
implements CloseableAvailableByteBody {
    private final long length;
    @Nullable
    private ByteBuf buffer;

    public AvailableNettyByteBody(@NonNull ByteBuf buffer) {
        this.buffer = Objects.requireNonNull(buffer, "buffer");
        this.length = buffer.readableBytes();
    }

    public static CloseableAvailableByteBody empty() {
        return new AvailableNettyByteBody(Unpooled.EMPTY_BUFFER);
    }

    public static ByteBuf toByteBuf(AvailableByteBody body) {
        if (body instanceof AvailableNettyByteBody) {
            AvailableNettyByteBody net = (AvailableNettyByteBody)body;
            return net.claim();
        }
        return Unpooled.wrappedBuffer(body.toByteArray());
    }

    public ByteBuf peek() {
        ByteBuf b = this.buffer;
        if (b == null) {
            throw new IllegalStateException("Body already claimed.");
        }
        return b;
    }

    @Override
    @NonNull
    public InputStream toInputStream() {
        return new ByteBufInputStream(this.claim(), true);
    }

    @Override
    public long length() {
        return this.length;
    }

    @NonNull
    private ByteBuf claim() {
        ByteBuf b = this.buffer;
        if (b == null) {
            AvailableNettyByteBody.failClaim();
        }
        this.buffer = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Body claimed at this location. This is not an error, but may aid in debugging other errors", new Exception());
        }
        return b;
    }

    @Override
    @NonNull
    public ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow() {
        return ExecutionFlow.just(new AvailableNettyByteBody(this.claim()));
    }

    @Override
    public void close() {
        ByteBuf b = this.buffer;
        this.buffer = null;
        if (b != null) {
            b.release();
        }
    }

    @Override
    protected Flux<ByteBuf> toByteBufPublisher() {
        return Flux.just(this.claim());
    }

    @Override
    public byte @NonNull [] toByteArray() {
        ByteBuf b = this.claim();
        try {
            byte[] byArray = ByteBufUtil.getBytes(b);
            return byArray;
        }
        finally {
            b.release();
        }
    }

    @Override
    @NonNull
    public ByteBuffer<?> toByteBuffer() {
        return NettyByteBufferFactory.DEFAULT.wrap(this.claim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public String toString(Charset charset) {
        ByteBuf b = this.claim();
        try {
            String string = b.toString(charset);
            return string;
        }
        finally {
            b.release();
        }
    }

    @Override
    @NonNull
    public CloseableAvailableByteBody split() {
        ByteBuf b = this.buffer;
        if (b == null) {
            AvailableNettyByteBody.failClaim();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Body split at this location. This is not an error, but may aid in debugging other errors", new Exception());
        }
        return new AvailableNettyByteBody(b.retainedSlice());
    }
}

