/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.multipart;

import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.multipart.CompletedPart;
import io.micronaut.http.server.multipart.MultipartBody;
import io.micronaut.http.server.netty.FormDataHttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentProcessorAsReactiveProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.body.NettyByteBody;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.multipart.NettyCompletedAttribute;
import io.micronaut.http.server.netty.multipart.NettyCompletedFileUpload;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.util.ReferenceCounted;
import java.util.HashSet;
import java.util.Optional;
import reactor.core.publisher.Flux;

@Internal
public class MultipartBodyArgumentBinder
implements NonBlockingBodyArgumentBinder<MultipartBody> {
    private final BeanProvider<NettyHttpServerConfiguration> httpServerConfiguration;

    public MultipartBodyArgumentBinder(BeanProvider<NettyHttpServerConfiguration> httpServerConfiguration) {
        this.httpServerConfiguration = httpServerConfiguration;
    }

    @Override
    public Argument<MultipartBody> argumentType() {
        return Argument.of(MultipartBody.class);
    }

    @Override
    public ArgumentBinder.BindingResult<MultipartBody> bind(ArgumentConversionContext<MultipartBody> context, HttpRequest<?> source) {
        if (source instanceof NettyHttpRequest) {
            Flux<HttpData> multiObjectBody;
            NettyHttpRequest nhr = (NettyHttpRequest)source;
            FormDataHttpContentProcessor processor = new FormDataHttpContentProcessor(nhr, this.httpServerConfiguration.get());
            try {
                multiObjectBody = HttpContentProcessorAsReactiveProcessor.asPublisher(processor, NettyByteBody.toByteBufs(nhr.byteBody()).map(DefaultHttpContent::new));
            }
            catch (Throwable e) {
                return () -> Optional.of(Flux.error(e)::subscribe);
            }
            HashSet partial = new HashSet();
            Flux<CompletedPart> completed = multiObjectBody.mapNotNull(message -> {
                if (message.isCompleted() && message.length() != 0L) {
                    partial.remove(message);
                    if (message instanceof FileUpload) {
                        FileUpload fu = (FileUpload)message;
                        return new NettyCompletedFileUpload(fu, true);
                    }
                    return new NettyCompletedAttribute((Attribute)message, true);
                }
                partial.add(message);
                return null;
            }).doOnTerminate(() -> partial.forEach(ReferenceCounted::release));
            return () -> Optional.of(completed::subscribe);
        }
        return ArgumentBinder.BindingResult.empty();
    }
}

