/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import java.util.Optional;

@ConfigurationProperties(value="endpoints.all")
public class EndpointDefaultConfiguration {
    public static final String PREFIX = "endpoints.all";
    public static final String PATH = "endpoints.all.path";
    public static final String CONTEXT_PATH = "endpoints.all.context.path";
    public static final String PORT = "endpoints.all.port";
    public static final String DEFAULT_ENDPOINT_BASE_PATH = "/";
    public static final String DEFAULT_ENDPOINT_CONTEXT_PATH = null;
    private Boolean enabled;
    private Boolean sensitive;
    private Integer port;
    private String path = "/";
    private String contextPath = DEFAULT_ENDPOINT_CONTEXT_PATH;

    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getContextPath() {
        return this.contextPath;
    }

    public Optional<Boolean> isEnabled() {
        return Optional.ofNullable(this.enabled);
    }

    public Optional<Boolean> isSensitive() {
        return Optional.ofNullable(this.sensitive);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    public void setPath(String path) {
        if (StringUtils.isNotEmpty(path)) {
            this.path = path;
        }
    }

    public void setContextPath(String contextPath) {
        if (StringUtils.isNotEmpty(contextPath)) {
            this.contextPath = contextPath;
        }
    }

    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    public void setPort(@Nullable Integer port) {
        this.port = port;
    }
}

