/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import java.io.IOException;

@Internal
class ErrorCatchingSerializer<T>
implements Serializer<T> {
    private final Serializer<T> serializer;

    ErrorCatchingSerializer(Serializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public final void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T values) throws IOException {
        try {
            this.serializer.serialize(encoder, context, (Argument<? extends T>)type, (T)values);
        }
        catch (StackOverflowError e) {
            throw new SerdeException("Infinite recursion serializing type: " + type.getType().getSimpleName() + " at path " + encoder.currentPath(), e);
        }
        catch (IntrospectionException e) {
            throw new SerdeException("Error serializing value at path: " + encoder.currentPath() + ". No serializer found for type: " + type, e);
        }
        catch (SerdeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerdeException("Error serializing value at path: " + encoder.currentPath(), e);
        }
    }

    @Override
    public final Serializer<T> createSpecific(Serializer.EncoderContext context, Argument<? extends T> type) throws SerdeException {
        return this.serializer.createSpecific(context, type);
    }

    @Override
    public final boolean isEmpty(Serializer.EncoderContext context, T value) {
        return this.serializer.isEmpty(context, value);
    }

    @Override
    public final boolean isAbsent(Serializer.EncoderContext context, T value) {
        return this.serializer.isAbsent(context, value);
    }

    public final Serializer<T> getSerializer() {
        return this.serializer;
    }
}

